/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appserver.defaultprovider;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.examples.appserver.defaultprovider.Customer;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerAdapter
extends AbstractEntityCollectionAdapter<Customer> {
    private static final String ID_PREFIX = "urn:acme:customer:";
    private AtomicInteger nextId = new AtomicInteger(1000);
    private Map<Integer, Customer> customers = new HashMap<Integer, Customer>();
    private Factory factory = new Abdera().getFactory();

    public String getId(RequestContext request) {
        return "tag:example.org,2007:feed";
    }

    public ResponseContext getCategories(RequestContext request) {
        return null;
    }

    public Customer postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        Customer customer = this.contentToCustomer(content);
        this.customers.put(customer.getId(), customer);
        return customer;
    }

    private Customer contentToCustomer(Content content) {
        Customer customer = new Customer();
        return this.contentToCustomer(content, customer);
    }

    private Customer contentToCustomer(Content content, Customer customer) {
        Element firstChild = content.getFirstChild();
        customer.setName(firstChild.getAttributeValue("name"));
        customer.setId(this.nextId.incrementAndGet());
        return customer;
    }

    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Integer id = this.getIdFromResourceName(resourceName);
        this.customers.remove(id);
    }

    public String getAuthor(RequestContext request) {
        return "Acme Industries";
    }

    public List<Person> getAuthors(Customer entry, RequestContext request) throws ResponseContextException {
        Person author = request.getAbdera().getFactory().newAuthor();
        author.setName("Acme Industries");
        return Arrays.asList(author);
    }

    public Object getContent(Customer entry, RequestContext request) {
        Content content = this.factory.newContent();
        Element customerEl = this.factory.newElement(new QName("customer"));
        customerEl.setAttributeValue(new QName("name"), entry.getName());
        content.setValueElement(customerEl);
        return content;
    }

    public Iterable<Customer> getEntries(RequestContext request) {
        return this.customers.values();
    }

    public Customer getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Integer id = this.getIdFromResourceName(resourceName);
        return this.customers.get(id);
    }

    private Integer getIdFromResourceName(String resourceName) throws ResponseContextException {
        int idx = resourceName.indexOf("-");
        if (idx == -1) {
            throw new ResponseContextException(404);
        }
        Integer id = new Integer(resourceName.substring(0, idx));
        return id;
    }

    public Customer getEntryFromId(String id, RequestContext request) {
        return this.customers.get(new Integer(id));
    }

    public String getId(Customer entry) {
        return ID_PREFIX + entry.getId();
    }

    public String getName(Customer entry) {
        return entry.getId() + "-" + entry.getName().replaceAll(" ", "_");
    }

    public String getTitle(RequestContext request) {
        return "Acme Customer Database";
    }

    public String getTitle(Customer entry) {
        return entry.getName();
    }

    public Date getUpdated(Customer entry) {
        return new Date();
    }

    public void putEntry(Customer entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        this.contentToCustomer(content, entry);
    }
}

