/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appserver.employee;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.examples.appserver.employee.Employee;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmployeeCollectionAdapter
extends AbstractEntityCollectionAdapter<Employee> {
    private static final String ID_PREFIX = "urn:acme:customer:";
    private AtomicInteger nextId = new AtomicInteger(1000);
    private Map<Integer, Employee> customers = new HashMap<Integer, Employee>();
    private Factory factory = new Abdera().getFactory();

    public String getId(RequestContext request) {
        return "tag:acome.com,2007:employee:feed";
    }

    public String getTitle(RequestContext request) {
        return "Acme Employee Database";
    }

    public String getAuthor() {
        return "Acme Industries";
    }

    public Employee postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        Employee customer = this.contentToCustomer(content);
        this.customers.put(customer.getId(), customer);
        return customer;
    }

    private Employee contentToCustomer(Content content) {
        Employee customer = new Employee();
        return this.contentToCustomer(content, customer);
    }

    private Employee contentToCustomer(Content content, Employee customer) {
        Element firstChild = content.getFirstChild();
        customer.setName(firstChild.getAttributeValue("name"));
        customer.setId(this.nextId.incrementAndGet());
        return customer;
    }

    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Integer id = this.getIdFromResourceName(resourceName);
        this.customers.remove(id);
    }

    public List<Person> getAuthors(Employee entry, RequestContext request) throws ResponseContextException {
        Person author = request.getAbdera().getFactory().newAuthor();
        author.setName("Acme Industries");
        return Arrays.asList(author);
    }

    public Object getContent(Employee entry, RequestContext request) {
        Content content = this.factory.newContent();
        Element customerEl = this.factory.newElement(new QName("customer"));
        customerEl.setAttributeValue(new QName("name"), entry.getName());
        content.setValueElement(customerEl);
        return content;
    }

    public Iterable<Employee> getEntries(RequestContext request) {
        return this.customers.values();
    }

    public Employee getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Integer id = this.getIdFromResourceName(resourceName);
        return this.customers.get(id);
    }

    private Integer getIdFromResourceName(String resourceName) throws ResponseContextException {
        int idx = resourceName.indexOf("-");
        if (idx == -1) {
            throw new ResponseContextException(404);
        }
        return new Integer(resourceName.substring(0, idx));
    }

    public String getId(Employee entry) {
        return ID_PREFIX + entry.getId();
    }

    public String getName(Employee entry) {
        return String.valueOf(entry.getId()) + "-" + entry.getName().replaceAll(" ", "_");
    }

    public String getTitle(Employee entry) {
        return entry.getName();
    }

    public Date getUpdated(Employee entry) {
        return new Date();
    }

    public void putEntry(Employee entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        this.contentToCustomer(content, entry);
    }
}

