/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.Signature;
import org.apache.abdera.security.SignatureOptions;

public class DSig {
    private static final String keystoreFile = "/key.jks";
    private static final String keystoreType = "JKS";
    private static final String keystorePass = "testing";
    private static final String privateKeyAlias = "James";
    private static final String privateKeyPass = "testing";
    private static final String certificateAlias = "James";

    public static void main(String[] args) throws Exception {
        KeyStore ks = KeyStore.getInstance(keystoreType);
        InputStream in = DSig.class.getResourceAsStream(keystoreFile);
        ks.load(in, "testing".toCharArray());
        PrivateKey signingKey = (PrivateKey)ks.getKey("James", "testing".toCharArray());
        X509Certificate cert = (X509Certificate)ks.getCertificate("James");
        Abdera abdera = new Abdera();
        AbderaSecurity absec = new AbderaSecurity(abdera);
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId("http://example.org/foo/entry");
        entry.setUpdated(new Date());
        entry.setTitle("This is an entry");
        entry.setContentAsXhtml("This <b>is</b> <i>markup</i>");
        entry.addAuthor("James");
        entry.addLink("http://www.example.org");
        Signature sig = absec.getSignature();
        SignatureOptions options = sig.getDefaultSignatureOptions();
        options.setCertificate(cert);
        options.setSigningKey(signingKey);
        entry = (Entry)sig.sign((Element)entry, options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entry.writeTo((OutputStream)out);
        ByteArrayInputStream bais = new ByteArrayInputStream(out.toByteArray());
        Document entry_doc = abdera.getParser().parse((InputStream)bais);
        entry = (Entry)entry_doc.getRoot();
        System.out.println("Valid? " + sig.verify((Element)entry, null));
        entry.setTitle("Change the title");
        System.out.println("Valid after changing the title? " + sig.verify((Element)entry, null));
        entry = (Entry)sig.removeInvalidSignatures((Element)entry, options);
    }
}

