/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appserver;

import java.io.IOException;
import java.util.Date;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.AbstractProvider;
import org.apache.abdera.protocol.server.impl.BaseResponseContext;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.StreamWriterResponseContext;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProvider
extends AbstractProvider
implements Provider {
    private EntityTag service_etag = new EntityTag("simple");
    private Document<Feed> feed_doc;

    public SimpleProvider() {
        super(10);
    }

    private Document<Feed> init_feed_doc(Abdera abdera) {
        Factory factory = abdera.getFactory();
        Feed feed = factory.newFeed();
        try {
            feed.setId("tag:example.org,2006:feed");
            feed.setTitle("Simple");
            feed.setUpdated(new Date());
            feed.addLink("");
            feed.addLink("", "self");
            feed.addAuthor("Simple");
        }
        catch (Exception e) {
            // empty catch block
        }
        return feed.getDocument();
    }

    private synchronized Document<Feed> get_feed_doc(Abdera abdera) {
        if (this.feed_doc == null) {
            this.feed_doc = this.init_feed_doc(abdera);
        }
        return this.feed_doc;
    }

    public ResponseContext getService(RequestContext request) {
        Abdera abdera = request.getAbdera();
        StreamWriterResponseContext rc = new StreamWriterResponseContext(abdera){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startWorkspace().writeTitle("Simple").startCollection("atom/feed").writeTitle("Simple").writeAcceptsEntry().startCategories(false).endCategories().endCollection().endWorkspace().endDocument();
            }
        };
        rc.setEntityTag(this.service_etag);
        return rc;
    }

    public ResponseContext getFeed(RequestContext request) {
        Abdera abdera = request.getAbdera();
        Document<Feed> feed = this.get_feed_doc(abdera);
        BaseResponseContext rc = new BaseResponseContext(feed);
        rc.setEntityTag(this.calculateEntityTag((Base)feed.getRoot()));
        return rc;
    }

    public ResponseContext createEntry(RequestContext request) {
        Abdera abdera = request.getAbdera();
        Factory factory = abdera.getFactory();
        Parser parser = abdera.getParser();
        try {
            String ctype;
            MimeType contentType = request.getContentType();
            String string = ctype = contentType != null ? contentType.toString() : null;
            if (ctype != null && !MimeTypeHelper.isAtom((String)ctype) && !MimeTypeHelper.isXml((String)ctype)) {
                return new EmptyResponseContext(415);
            }
            Document entry_doc = (Document)request.getDocument(parser).clone();
            if (entry_doc != null) {
                Entry entry = (Entry)entry_doc.getRoot();
                if (!SimpleProvider.isValidEntry((Entry)entry)) {
                    return new EmptyResponseContext(400);
                }
                entry.setUpdated(new Date());
                entry.getIdElement().setValue(factory.newUuidUri());
                entry.addLink("feed/" + entry.getId().toString(), "edit");
                Feed feed = (Feed)this.get_feed_doc(abdera).getRoot();
                feed.insertEntry(entry);
                feed.setUpdated(new Date());
                BaseResponseContext rc = new BaseResponseContext((Base)entry);
                IRI baseUri = this.resolveBase(request);
                rc.setLocation(baseUri.resolve(entry.getEditLinkResolvedHref()).toString());
                rc.setContentLocation(rc.getLocation().toString());
                rc.setEntityTag(this.calculateEntityTag((Base)entry));
                rc.setStatus(201);
                return rc;
            }
            return new EmptyResponseContext(400);
        }
        catch (ParseException pe) {
            return new EmptyResponseContext(415);
        }
        catch (ClassCastException cce) {
            return new EmptyResponseContext(415);
        }
        catch (Exception e) {
            return new EmptyResponseContext(400);
        }
    }

    public ResponseContext deleteEntry(RequestContext request) {
        Entry entry = this.getAbderaEntry(request);
        if (entry != null) {
            entry.discard();
        }
        return new EmptyResponseContext(204);
    }

    public ResponseContext getEntry(RequestContext request) {
        Entry entry = this.getAbderaEntry(request);
        if (entry != null) {
            Feed feed = (Feed)entry.getParentElement();
            entry = (Entry)entry.clone();
            entry.setSource(feed.getAsSource());
            Document entry_doc = entry.getDocument();
            BaseResponseContext rc = new BaseResponseContext((Base)entry_doc);
            rc.setEntityTag(this.calculateEntityTag((Base)entry));
            return rc;
        }
        return new EmptyResponseContext(404);
    }

    public ResponseContext updateEntry(RequestContext request) {
        Abdera abdera = request.getAbdera();
        Parser parser = abdera.getParser();
        Factory factory = abdera.getFactory();
        Entry orig_entry = this.getAbderaEntry(request);
        if (orig_entry != null) {
            try {
                MimeType contentType = request.getContentType();
                if (contentType != null && !MimeTypeHelper.isAtom((String)contentType.toString())) {
                    return new EmptyResponseContext(415);
                }
                Document entry_doc = (Document)request.getDocument(parser).clone();
                if (entry_doc != null) {
                    Entry entry = (Entry)entry_doc.getRoot();
                    if (!entry.getId().equals((Object)orig_entry.getId())) {
                        return new EmptyResponseContext(409);
                    }
                    if (!SimpleProvider.isValidEntry((Entry)entry)) {
                        return new EmptyResponseContext(400);
                    }
                    entry.setUpdated(new Date());
                    entry.getIdElement().setValue(factory.newUuidUri());
                    entry.addLink("atom/feed/" + entry.getId().toString(), "edit");
                    orig_entry.discard();
                    Feed feed = (Feed)this.get_feed_doc(abdera).getRoot();
                    feed.insertEntry(entry);
                    feed.setUpdated(new Date());
                    return new EmptyResponseContext(204);
                }
                return new EmptyResponseContext(400);
            }
            catch (ParseException pe) {
                return new EmptyResponseContext(415);
            }
            catch (ClassCastException cce) {
                return new EmptyResponseContext(415);
            }
            catch (Exception e) {
                return new EmptyResponseContext(400);
            }
        }
        return new EmptyResponseContext(404);
    }

    private EntityTag calculateEntityTag(Base base) {
        String id = null;
        String modified = null;
        if (base instanceof Entry) {
            id = ((Entry)base).getId().toString();
            modified = ((Entry)base).getUpdatedElement().getText();
        } else if (base instanceof Feed) {
            id = ((Feed)base).getId().toString();
            modified = ((Feed)base).getUpdatedElement().getText();
        }
        return EntityTag.generate((String[])new String[]{id, modified});
    }

    private Entry getAbderaEntry(RequestContext request) {
        Abdera abdera = request.getAbdera();
        String entry_id = this.getEntryID(request);
        Document<Feed> feed = this.get_feed_doc(abdera);
        try {
            return ((Feed)feed.getRoot()).getEntry(entry_id);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getEntryID(RequestContext request) {
        if (request.getTarget().getType() != TargetType.TYPE_ENTRY) {
            return null;
        }
        String path = request.getUri().toString();
        String[] segments = path.split("/");
        return segments[segments.length - 1];
    }
}

