/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.security;

import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.abdera.security.util.DHContext;

public class DHEnc {
    public static void main(String[] args) throws Exception {
        Provider p;
        Class<?> provider;
        String jce;
        Abdera abdera = new Abdera();
        try {
            jce = abdera.getConfiguration().getConfigurationOption("jce.provider", "org.bouncycastle.jce.provider.BouncyCastleProvider");
            provider = Class.forName(jce);
            p = (Provider)provider.newInstance();
            Security.addProvider(p);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jce = abdera.getConfiguration().getConfigurationOption("jce.provider", "org.bouncycastle.jce.provider.BouncyCastleProvider");
            provider = Class.forName(jce);
            p = (Provider)provider.newInstance();
            Security.addProvider(p);
        }
        catch (Exception e) {
            throw new RuntimeException("The Configured JCE Provider is not available");
        }
        AbderaSecurity absec = new AbderaSecurity(abdera);
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId("http://example.org/foo/entry");
        entry.setUpdated(new Date());
        entry.setTitle("This is an entry");
        entry.setContentAsXhtml("This <b>is</b> <i>markup</i>");
        entry.addAuthor("James");
        entry.addLink("http://www.example.org");
        DHContext context_a = new DHContext();
        DHContext context_b = new DHContext(context_a.getRequestString());
        context_a.setPublicKey(context_b.getResponseString());
        Encryption enc = absec.getEncryption();
        EncryptionOptions options = context_a.getEncryptionOptions(enc);
        Document enc_doc = enc.encrypt(entry.getDocument(), options);
        enc_doc.writeTo((OutputStream)System.out);
        System.out.println("\n\n");
        options = context_b.getEncryptionOptions(enc);
        Document entry_doc = enc.decrypt(enc_doc, options);
        entry_doc.writeTo((OutputStream)System.out);
    }
}

