/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.geo;

import java.util.Iterator;
import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.Coordinates;
import org.apache.abdera.ext.geo.Point;
import org.apache.abdera.ext.geo.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Multiple
extends Position
implements Iterable<Coordinate> {
    protected Coordinates coordinates;

    public Multiple() {
    }

    public Multiple(Multiple ... multiples) {
        this.coordinates = new Coordinates();
        Multiple[] multipleArray = multiples;
        int n = multiples.length;
        int n2 = 0;
        while (n2 < n) {
            Multiple m = multipleArray[n2];
            this.coordinates.add(m.getCoordinates());
            ++n2;
        }
    }

    public Multiple(Multiple multiple) {
        this(multiple.getCoordinates().clone());
    }

    public Multiple(Point point) {
        this(point.getCoordinate().clone());
    }

    public Multiple(Point ... points) {
        this.coordinates = new Coordinates();
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            this.coordinates.add(p.getCoordinate());
            ++n2;
        }
    }

    public Multiple(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public Multiple(Coordinate ... coordinates) {
        this.coordinates = new Coordinates(coordinates);
    }

    public Multiple(String value) {
        this.coordinates = new Coordinates(value);
    }

    public Multiple(double ... values) {
        this.coordinates = new Coordinates();
        int n = 0;
        while (n < values.length) {
            Coordinate c = new Coordinate(values[n], values[n + 1]);
            this.coordinates.add(c);
            n += 2;
        }
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public Iterator<Coordinate> iterator() {
        return this.coordinates.iterator();
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Multiple other = (Multiple)obj;
        return !(this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates));
    }

    @Override
    public int compareTo(Position o) {
        if (o == null || !this.getClass().isInstance(o) || this.equals(o)) {
            return 0;
        }
        return this.coordinates.compareTo(((Multiple)o).coordinates);
    }

    protected void verify179Rule() {
        for (Coordinate c1 : this.getCoordinates()) {
            for (Coordinate c2 : this.getCoordinates()) {
                this.check179(c1.getLatitude(), c2.getLatitude());
                this.check179(c1.getLongitude(), c2.getLongitude());
            }
        }
    }

    private void check179(double d1, double d2) {
        if (Math.max(d1, d2) - Math.min(d1, d2) > 179.0) {
            throw new RuntimeException("Values are greater than 179 degrees");
        }
    }
}

