/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.html;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.htmlparser.sax.HtmlSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HtmlCleaner {
    private HtmlCleaner() {
    }

    public static String parse(String value) {
        return HtmlCleaner.parse(new StringReader(value), true);
    }

    public static String parse(InputStream in) {
        return HtmlCleaner.parse(in, "UTF-8");
    }

    public static String parse(InputStream in, String charset) {
        try {
            return HtmlCleaner.parse(new InputStreamReader(in, charset), true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String parse(Reader in, boolean fragment) {
        try {
            HtmlParser htmlParser = new HtmlParser();
            htmlParser.setBogusXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
            htmlParser.setMappingLangToXmlLang(true);
            htmlParser.setReportingDoctype(false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            VoidElementFixHtmlSerializer ser = new VoidElementFixHtmlSerializer(w);
            htmlParser.setContentHandler((ContentHandler)((Object)ser));
            htmlParser.setLexicalHandler((LexicalHandler)((Object)ser));
            if (!fragment) {
                htmlParser.parse(new InputSource(in));
            } else {
                htmlParser.parseFragment(new InputSource(in), "div");
            }
            try {
                ((Writer)w).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private static class VoidElementFixHtmlSerializer
    extends HtmlSerializer {
        private static final String[] VOID_ELEMENTS = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "embed", "frame", "hr", "img", "input", "link", "meta", "param", "spacer", "wbr"};
        private final Writer writer;

        public VoidElementFixHtmlSerializer(Writer out) {
            super(out);
            this.writer = out;
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (Arrays.binarySearch(VOID_ELEMENTS, localName) > -1) {
                try {
                    this.writer.write(60);
                    this.writer.write(47);
                    this.writer.write(localName);
                    this.writer.write(62);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            super.endElement(uri, localName, name);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            StringBuilder buf = new StringBuilder();
            int n = start;
            while (n < start + length) {
                if (ch[n] == '<') {
                    buf.append("&lt;");
                } else if (ch[n] == '>') {
                    buf.append("&gt;");
                } else if (ch[n] == '&') {
                    boolean isentity = false;
                    int i = n;
                    String ent = null;
                    while (i < start + length) {
                        if (ch[i] == ';') {
                            ent = new String(ch, n, i - n + 1);
                            isentity = ent.matches("\\&[\\w]*\\;");
                            break;
                        }
                        ++i;
                    }
                    if (isentity) {
                        buf.append(ent);
                        n = i;
                    } else {
                        buf.append("&amp;");
                    }
                } else {
                    buf.append(ch[n]);
                }
                ++n;
            }
            super.characters(buf.toString().toCharArray(), 0, buf.length());
        }
    }
}

