/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.html.HtmlCleaner;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.util.XmlRestrictedCharReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlHelper {
    private HtmlHelper() {
    }

    public static Div parse(String value) {
        return HtmlHelper.parse(Abdera.getInstance(), value);
    }

    public static Div parse(InputStream in) {
        return HtmlHelper.parse(Abdera.getInstance(), in);
    }

    public static Div parse(InputStream in, String charset) {
        return HtmlHelper.parse(Abdera.getInstance(), in, charset);
    }

    public static Div parse(Reader in) {
        return HtmlHelper.parse(Abdera.getInstance(), in);
    }

    public static Div parse(Abdera abdera, String value) {
        return HtmlHelper.parse(abdera, new StringReader(value));
    }

    public static Div parse(Abdera abdera, InputStream in) {
        return HtmlHelper.parse(abdera, in, "UTF-8");
    }

    public static Div parse(Abdera abdera, InputStream in, String charset) {
        try {
            return HtmlHelper.parse(abdera, new InputStreamReader(in, charset));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Div parse(Abdera abdera, Reader in) {
        String result = null;
        Div div = abdera.getFactory().newDiv();
        try {
            div.setValue(HtmlCleaner.parse(in, true));
            return div;
        }
        catch (Exception e) {
            if (result != null) {
                div.setText(result);
            }
            return div;
        }
    }

    public static Document<Element> parseDocument(Reader in) {
        return HtmlHelper.parseDocument(Abdera.getInstance(), in);
    }

    public static Document<Element> parseDocument(Abdera abdera, Reader in) {
        return abdera.getParser().parse((Reader)new StringReader(HtmlCleaner.parse(in, false)));
    }

    public static List<Element> discoverLinks(Element base, String type, String ... rel) {
        ArrayList<Element> results = new ArrayList<Element>();
        HtmlHelper.walkElementForLinks(results, base, rel, type);
        return results;
    }

    private static void walkElementForLinks(List<Element> results, Element base, String[] rel, String type) {
        if (HtmlHelper.checkElementForLink(base, rel, type)) {
            results.add(base);
        }
        for (Element child : base.getElements()) {
            HtmlHelper.walkElementForLinks(results, child, rel, type);
        }
    }

    private static boolean checkElementForLink(Element base, String[] relvals, String type) {
        if (base.getQName().getLocalPart().equalsIgnoreCase("link")) {
            String relattr = base.getAttributeValue("rel");
            String typeattr = base.getAttributeValue("type");
            if (relattr != null) {
                Object[] rels = relattr.split("\\s+");
                Arrays.sort(rels);
                String[] stringArray = relvals;
                int n = relvals.length;
                int n2 = 0;
                while (n2 < n) {
                    String rel = stringArray[n2];
                    if (Arrays.binarySearch(rels, rel) < 0) {
                        return false;
                    }
                    ++n2;
                }
            }
            if (type != null && typeattr == null) {
                return false;
            }
            if (type == null && typeattr != null) {
                return true;
            }
            if (MimeTypeHelper.isMatch((String)type, (String)typeattr)) {
                return true;
            }
        }
        return false;
    }

    public static List<Element> discoverLinks(String uri, String type, String ... rel) throws IOException {
        return HtmlHelper.discoverLinks(Abdera.getInstance(), uri, type, rel);
    }

    public static List<Element> discoverLinks(Abdera abdera, String uri, String type, String ... rel) throws IOException {
        AbderaClient client = new AbderaClient(abdera);
        ClientResponse resp = client.get(uri);
        InputStream in = resp.getInputStream();
        InputStreamReader r = new InputStreamReader(in);
        XmlRestrictedCharReader x = new XmlRestrictedCharReader((Reader)r);
        Document<Element> doc = HtmlHelper.parseDocument((Reader)x);
        List<Element> list = HtmlHelper.discoverLinks(doc.getRoot(), type, rel);
        return list;
    }
}

