/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.features;

import java.util.ArrayList;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.features.FeaturesHelper;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.util.MimeTypeHelper;

public class Feature
extends ExtensibleElementWrapper {
    public Feature(Element internal) {
        super(internal);
    }

    public Feature(Factory factory) {
        super(factory, FeaturesHelper.FEATURE);
    }

    public IRI getRef() {
        String ref = this.getAttributeValue("ref");
        return ref != null ? new IRI(ref) : null;
    }

    public IRI getHref() {
        String href = this.getAttributeValue("href");
        return href != null ? new IRI(href) : null;
    }

    public String getLabel() {
        return this.getAttributeValue("label");
    }

    public void setRef(String ref) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        this.setAttributeValue("ref", new IRI(ref).toString());
    }

    public void setHref(String href) {
        if (href != null) {
            this.setAttributeValue("href", new IRI(href).toString());
        } else {
            this.removeAttribute(new QName("href"));
        }
    }

    public void setLabel(String label) {
        if (label != null) {
            this.setAttributeValue("label", label);
        } else {
            this.removeAttribute(new QName("label"));
        }
    }

    public void addType(String mediaRange) {
        this.addType(new String[]{mediaRange});
    }

    public void addType(String ... mediaRanges) {
        String[] stringArray = mediaRanges = MimeTypeHelper.condense((String[])mediaRanges);
        int n = mediaRanges.length;
        int n2 = 0;
        while (n2 < n) {
            String mediaRange = stringArray[n2];
            try {
                this.addSimpleExtension(FeaturesHelper.TYPE, new MimeType(mediaRange).toString());
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public String[] getTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Element type : this.getExtensions(FeaturesHelper.TYPE)) {
            String value = type.getText();
            if (value == null) continue;
            value = value.trim();
            try {
                list.add(new MimeType(value).toString());
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                // empty catch block
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

