/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.ext.features.AbstractSelector;
import org.apache.abdera.ext.features.FeaturesHelper;
import org.apache.abdera.ext.features.Selector;
import org.apache.abdera.model.Collection;

public class FeatureSelector
extends AbstractSelector
implements Selector {
    private static final long serialVersionUID = -8943638085557912175L;
    private final List<String> features = new ArrayList<String>();

    public FeatureSelector(String ... features) {
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            this.features.add(feature);
            ++n2;
        }
    }

    public boolean select(Collection collection) {
        for (String feature : this.features) {
            FeaturesHelper.Status status = FeaturesHelper.getFeatureStatus(collection, feature);
            if (status != FeaturesHelper.Status.SPECIFIED) continue;
            return true;
        }
        return false;
    }

    public String[] getFeatures() {
        return this.features.toArray(new String[this.features.size()]);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureSelector other = (FeatureSelector)obj;
        return !(this.features == null ? other.features != null : !this.features.equals(other.features));
    }

    protected Selector copy() {
        return new FeatureSelector(this.getFeatures());
    }
}

