/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.features;

import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.features.AbstractSelector;
import org.apache.abdera.ext.features.Selector;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Collection;
import org.apache.abdera.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathSelector
extends AbstractSelector
implements Selector {
    private static final long serialVersionUID = 7751803876821166591L;
    private final XPath xpath;
    private final Map<String, String> namespaces;
    private final String path;

    public XPathSelector(String path) {
        this(path, new Abdera().getXPath());
    }

    public XPathSelector(String path, XPath xpath) {
        this(path, xpath, xpath.getDefaultNamespaces());
    }

    public XPathSelector(String path, XPath xpath, Map<String, String> namespaces) {
        this.path = path;
        this.xpath = xpath;
        this.namespaces = namespaces;
        if (!this.namespaces.containsValue("http://purl.org/atompub/features/1.0")) {
            int c = 0;
            String p = "f";
            if (!this.namespaces.containsKey(p)) {
                this.namespaces.put(p, "http://purl.org/atompub/features/1.0");
            } else {
                String s = String.valueOf(p) + c;
                while (this.namespaces.containsKey(s)) {
                    s = String.valueOf(p) + ++c;
                }
                this.namespaces.put(s, "http://purl.org/atompub/features/1.0");
            }
        }
    }

    public String getFeaturesPrefix() {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals("http://purl.org/atompub/features/1.0")) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean select(Collection collection) {
        return this.xpath.booleanValueOf(this.path, (Base)collection, this.namespaces);
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }
}

