/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.bidi;

import java.text.AttributedString;
import java.text.Bidi;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.abdera.i18n.rfc4646.Lang;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BidiHelper {
    private static final QName DIR = new QName("dir");
    private static final String[] RTL_LANGS = new String[]{"ar", "dv", "fa", "he", "ps", "syr", "ur", "yi"};
    private static final String[] RTL_SCRIPTS = new String[]{"arab", "avst", "hebr", "hung", "lydi", "mand", "mani", "mero", "mong", "nkoo", "orkh", "phlv", "phnx", "samr", "syrc", "syre", "syrj", "syrn", "tfng", "thaa"};
    private static final String[] RTL_ENCODINGS = new String[]{"iso-8859-6", "iso-8859-6-bidi", "iso-8859-6-i", "iso-ir-127", "ecma-114", "asmo-708", "arabic", "csisolatinarabic", "windows-1256", "ibm-864", "macarabic", "macfarsi", "iso-8859-8-i", "iso-8859-8-bidi", "windows-1255", "iso-8859-8", "ibm-862", "machebrew", "asmo-449", "iso-9036", "arabic7", "iso-ir-89", "csiso89asmo449", "iso-unicode-ibm-1264", "csunicodeibm1264", "iso_8859-8:1988", "iso-ir-138", "hebrew", "csisolatinhebrew", "iso-unicode-ibm-1265", "csunicodeibm1265", "cp862", "862", "cspc862latinhebrew"};

    BidiHelper() {
    }

    public static <T extends Element> void setDirection(Direction direction, T element) {
        if (direction != Direction.UNSPECIFIED) {
            element.setAttributeValue(DIR, direction.toString().toLowerCase());
        } else if (direction == Direction.UNSPECIFIED) {
            element.setAttributeValue(DIR, "");
        } else if (direction == null) {
            element.removeAttribute(DIR);
        }
    }

    public static <T extends Element> Direction getDirection(T element) {
        Base parent;
        Direction direction = Direction.UNSPECIFIED;
        String dir = element.getAttributeValue("dir");
        if (dir != null && dir.length() > 0) {
            direction = Direction.valueOf(dir.toUpperCase());
        } else if (dir == null && (parent = element.getParentElement()) != null && parent instanceof Element) {
            direction = BidiHelper.getDirection((Element)parent);
        }
        return direction;
    }

    public static String getBidiText(Direction direction, String text) {
        switch (direction) {
            case LTR: {
                return CharUtils.wrapBidi((String)text, (char)'\u202a');
            }
            case RTL: {
                return CharUtils.wrapBidi((String)text, (char)'\u202b');
            }
        }
        return text;
    }

    public static <T extends Element> String getBidiChildText(T element, QName child) {
        Element el = element.getFirstChild(child);
        return el != null ? BidiHelper.getBidiText(BidiHelper.getDirection(el), el.getText()) : null;
    }

    public static <T extends Element> String getBidiElementText(T element) {
        return BidiHelper.getBidiText(BidiHelper.getDirection(element), element.getText());
    }

    public static <T extends Element> String getBidiAttributeValue(T element, String name) {
        return BidiHelper.getBidiText(BidiHelper.getDirection(element), element.getAttributeValue(name));
    }

    public static <T extends Element> String getBidiAttributeValue(T element, QName name) {
        return BidiHelper.getBidiText(BidiHelper.getDirection(element), element.getAttributeValue(name));
    }

    public static <T extends Element> Direction guessDirectionFromLanguage(T element) {
        return BidiHelper.guessDirectionFromLanguage(element, false);
    }

    public static <T extends Element> Direction guessDirectionFromLanguage(T element, boolean ignoredir) {
        String script;
        Lang lang;
        if (!ignoredir && BidiHelper.hasDirection(element)) {
            return BidiHelper.getDirection(element);
        }
        String language = element.getLanguage();
        Lang lang2 = lang = language != null ? new Lang(language) : new Lang(Locale.getDefault());
        if (lang.getScript() != null && Arrays.binarySearch(RTL_SCRIPTS, (script = lang.getScript().getName()).toLowerCase()) > -1) {
            return Direction.RTL;
        }
        String primary = lang.getLanguage().getName();
        if (Arrays.binarySearch(RTL_LANGS, primary.toLowerCase()) > -1) {
            return Direction.RTL;
        }
        return Direction.UNSPECIFIED;
    }

    public static <T extends Element> Direction guessDirectionFromEncoding(T element) {
        return BidiHelper.guessDirectionFromEncoding(element, false);
    }

    public static <T extends Element> Direction guessDirectionFromEncoding(T element, boolean ignoredir) {
        if (!ignoredir && BidiHelper.hasDirection(element)) {
            return BidiHelper.getDirection(element);
        }
        Document doc = element.getDocument();
        if (doc == null) {
            return Direction.UNSPECIFIED;
        }
        String charset = doc.getCharset();
        if (charset == null) {
            return Direction.UNSPECIFIED;
        }
        charset = charset.replace('_', '-');
        Arrays.sort(RTL_ENCODINGS);
        if (Arrays.binarySearch(RTL_ENCODINGS, charset.toLowerCase()) > -1) {
            return Direction.RTL;
        }
        return Direction.UNSPECIFIED;
    }

    public static <T extends Element> Direction guessDirectionFromTextProperties(T element) {
        return BidiHelper.guessDirectionFromTextProperties(element, false);
    }

    public static <T extends Element> Direction guessDirectionFromTextProperties(T element, boolean ignoredir) {
        Direction dir = Direction.UNSPECIFIED;
        if (!ignoredir && BidiHelper.hasDirection(element)) {
            return BidiHelper.getDirection(element);
        }
        String text = element.getText();
        if (text != null && text.length() > 0) {
            if (text.charAt(0) == '\u200f') {
                return Direction.RTL;
            }
            if (text.charAt(0) == '\u200e') {
                return Direction.LTR;
            }
            int c = 0;
            int n = 0;
            while (n < text.length()) {
                char ch = text.charAt(n);
                c = Bidi.requiresBidi(new char[]{ch}, 0, 1) ? ++c : --c;
                ++n;
            }
            dir = c > 0 ? Direction.RTL : Direction.LTR;
        }
        return dir;
    }

    public static <T extends Element> Direction guessDirectionFromJavaBidi(T element) {
        return BidiHelper.guessDirectionFromJavaBidi(element, false);
    }

    public static <T extends Element> Direction guessDirectionFromJavaBidi(T element, boolean ignoredir) {
        Direction dir = Direction.UNSPECIFIED;
        if (!ignoredir && BidiHelper.hasDirection(element)) {
            return BidiHelper.getDirection(element);
        }
        String text = element.getText();
        if (text != null) {
            AttributedString s = new AttributedString(text);
            Bidi bidi = new Bidi(s.getIterator());
            dir = bidi.baseIsLeftToRight() ? Direction.LTR : Direction.RTL;
        }
        return dir;
    }

    private static <T extends Element> boolean hasDirection(T element) {
        Base parent;
        boolean answer = false;
        String dir = element.getAttributeValue("dir");
        if (dir != null && dir.length() > 0) {
            answer = true;
        } else if (dir == null && (parent = element.getParentElement()) != null && parent instanceof Element) {
            answer = BidiHelper.hasDirection((Element)parent);
        }
        return answer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UNSPECIFIED,
        LTR,
        RTL;

    }
}

