/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import org.apache.abdera.ext.oauth.OAuthCredentials;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.util.MethodHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class OAuthScheme
extends RFC2617Scheme
implements AuthScheme {
    private final int NONCE_LENGTH = 16;

    public static void register(AbderaClient abderaClient, boolean exclusive) {
        AbderaClient.registerScheme((String)"OAuth", OAuthScheme.class);
        if (exclusive) {
            abderaClient.setAuthenticationSchemePriority(new String[]{"OAuth"});
        } else {
            abderaClient.setAuthenticationSchemeDefaults();
        }
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return this.authenticate(credentials, this.resolveMethod(method, uri));
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        if (credentials instanceof OAuthCredentials) {
            OAuthCredentials oauthCredentials = (OAuthCredentials)credentials;
            String nonce = this.generateNonce();
            long timestamp = new Date().getTime() / 1000L;
            String signature = this.generateSignature(oauthCredentials, method, nonce, timestamp);
            return "OAuth realm=\"" + oauthCredentials.getRealm() + "\", " + OAUTH_KEYS.OAUTH_CONSUMER_KEY.toLowerCase() + "=\"" + oauthCredentials.getConsumerKey() + "\", " + OAUTH_KEYS.OAUTH_TOKEN.toLowerCase() + "=\"" + oauthCredentials.getToken() + "\", " + OAUTH_KEYS.OAUTH_SIGNATURE_METHOD.toLowerCase() + "=\"" + oauthCredentials.getSignatureMethod() + "\", " + OAUTH_KEYS.OAUTH_SIGNATURE.toLowerCase() + "=\"" + signature + "\", " + OAUTH_KEYS.OAUTH_TIMESTAMP.toLowerCase() + "=\"" + timestamp + "\", " + OAUTH_KEYS.OAUTH_NONCE.toLowerCase() + "=\"" + nonce + "\", " + OAUTH_KEYS.OAUTH_VERSION.toLowerCase() + "=\"" + oauthCredentials.getVersion() + "\"";
        }
        return null;
    }

    private HttpMethod resolveMethod(String method, String uri) throws AuthenticationException {
        if (method.equalsIgnoreCase("get")) {
            return new GetMethod(uri);
        }
        if (method.equalsIgnoreCase("post")) {
            return new PostMethod(uri);
        }
        if (method.equalsIgnoreCase("put")) {
            return new PutMethod(uri);
        }
        if (method.equalsIgnoreCase("delete")) {
            return new DeleteMethod(uri);
        }
        if (method.equalsIgnoreCase("head")) {
            return new HeadMethod(uri);
        }
        if (method.equalsIgnoreCase("options")) {
            return new OptionsMethod(uri);
        }
        return new MethodHelper.ExtensionMethod(method, uri);
    }

    private String generateSignature(OAuthCredentials credentials, HttpMethod method, String nonce, long timestamp) throws AuthenticationException {
        try {
            String baseString = String.valueOf(method.getName().toUpperCase()) + method.getURI().toString() + OAUTH_KEYS.OAUTH_CONSUMER_KEY.toLowerCase() + "=" + credentials.getConsumerKey() + OAUTH_KEYS.OAUTH_TOKEN.toLowerCase() + "=" + credentials.getToken() + OAUTH_KEYS.OAUTH_SIGNATURE_METHOD.toLowerCase() + "=" + credentials.getSignatureMethod() + OAUTH_KEYS.OAUTH_TIMESTAMP.toLowerCase() + "=" + timestamp + OAUTH_KEYS.OAUTH_NONCE.toLowerCase() + "=" + nonce + OAUTH_KEYS.OAUTH_VERSION.toLowerCase() + "=" + credentials.getVersion();
            return this.sign(credentials.getSignatureMethod(), URLEncoder.encode(baseString, "UTF-8"), credentials.getCert());
        }
        catch (URIException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private String generateNonce() throws AuthenticationException {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[16];
            sr.nextBytes(temp);
            String n = new String(Hex.encodeHex((byte[])temp));
            return n;
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private String sign(String method, String baseString, Certificate cert) throws AuthenticationException {
        if (method.equalsIgnoreCase("HMAC-MD5") || method.equalsIgnoreCase("HMAC-SHA1")) {
            try {
                String[] tokens = method.split("-");
                String methodName = String.valueOf(tokens[0].substring(0, 1).toUpperCase()) + tokens[0].substring(1).toLowerCase() + tokens[1];
                KeyGenerator kg = KeyGenerator.getInstance(methodName);
                Mac mac = Mac.getInstance(kg.getAlgorithm());
                mac.init(kg.generateKey());
                byte[] result = mac.doFinal(baseString.getBytes());
                return new String(Base64.encodeBase64((byte[])result));
            }
            catch (Exception e) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e);
            }
        }
        if (method.equalsIgnoreCase("md5")) {
            return new String(Base64.encodeBase64((byte[])DigestUtils.md5((String)baseString)));
        }
        if (method.equalsIgnoreCase("sha1")) {
            return new String(Base64.encodeBase64((byte[])DigestUtils.sha((String)baseString)));
        }
        if (method.equalsIgnoreCase("RSA-SHA1")) {
            if (cert == null) {
                throw new AuthenticationException("a cert is mandatory to use SHA1 with RSA");
            }
            try {
                Cipher cipher = Cipher.getInstance("SHA1withRSA");
                cipher.init(1, cert);
                byte[] result = cipher.doFinal(baseString.getBytes());
                return new String(Base64.encodeBase64((byte[])result));
            }
            catch (Exception e) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e);
            }
        }
        throw new AuthenticationException("unsupported algorithm method: " + method);
    }

    public String getSchemeName() {
        return "OAuth";
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isConnectionBased() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OAUTH_KEYS {
        OAUTH_CONSUMER_KEY,
        OAUTH_TOKEN,
        OAUTH_SIGNATURE_METHOD,
        OAUTH_TIMESTAMP,
        OAUTH_NONCE,
        OAUTH_VERSION,
        OAUTH_SIGNATURE;


        public String toLowerCase() {
            return this.toString().toLowerCase();
        }
    }
}

