/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.opensearch.server.processors;

import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.ext.opensearch.server.OpenSearchInfo;
import org.apache.abdera.ext.opensearch.server.OpenSearchUrlAdapter;
import org.apache.abdera.ext.opensearch.server.OpenSearchUrlInfo;
import org.apache.abdera.ext.opensearch.server.OpenSearchUrlParameterInfo;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.RequestProcessor;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.WorkspaceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSearchUrlRequestProcessor
implements RequestProcessor {
    private OpenSearchInfo openSearchInfo;

    public ResponseContext process(RequestContext requestContext, WorkspaceManager workspaceManager, CollectionAdapter collectionAdapter) {
        String method = requestContext.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            OpenSearchUrlInfo urlInfo = this.getMatchingUrlInfo(requestContext);
            if (urlInfo != null) {
                OpenSearchUrlAdapter adapter = urlInfo.getOpenSearchUrlAdapter();
                if (adapter != null) {
                    Map<String, String> params = this.getUrlParametersFromRequest(requestContext, urlInfo);
                    return adapter.search(requestContext, params);
                }
                return ProviderHelper.notfound((RequestContext)requestContext);
            }
            return ProviderHelper.notfound((RequestContext)requestContext);
        }
        return null;
    }

    public void setOpenSearchInfo(OpenSearchInfo openSearchInfo) {
        this.openSearchInfo = openSearchInfo;
    }

    private OpenSearchUrlInfo getMatchingUrlInfo(RequestContext request) {
        String targetSearchPath = this.stripSlashes(request.getTargetPath().substring(0, request.getTargetPath().indexOf("?")));
        OpenSearchUrlInfo result = null;
        for (OpenSearchUrlInfo urlInfo : this.openSearchInfo.getUrls()) {
            String searchPath = this.stripSlashes(urlInfo.getSearchPath());
            if (!searchPath.equals(targetSearchPath)) continue;
            result = urlInfo;
            break;
        }
        return result;
    }

    private Map<String, String> getUrlParametersFromRequest(RequestContext request, OpenSearchUrlInfo urlInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (OpenSearchUrlParameterInfo paramInfo : urlInfo.getSearchParameters()) {
            String name = paramInfo.getName();
            String value = request.getParameter(name);
            if (value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    private String stripSlashes(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

