/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.opensearch.model;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.ext.opensearch.model.Query;
import org.apache.abdera.ext.opensearch.model.StringElement;
import org.apache.abdera.ext.opensearch.model.Url;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSearchDescription
extends ExtensibleElementWrapper {
    public OpenSearchDescription(Factory factory) {
        super(factory, OpenSearchConstants.OPENSEARCH_DESCRIPTION);
    }

    public OpenSearchDescription(Abdera abdera) {
        this(abdera.getFactory());
    }

    public OpenSearchDescription(Element internal) {
        super(internal);
    }

    public void setShortName(String shortName) {
        if (shortName == null) {
            shortName = "";
        }
        this.setExtensionStringValue(OpenSearchConstants.SHORT_NAME, shortName);
    }

    public String getShortName() {
        StringElement element = (StringElement)this.getExtension(OpenSearchConstants.SHORT_NAME);
        return element.getValue();
    }

    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.setExtensionStringValue(OpenSearchConstants.DESCRIPTION, description);
    }

    public String getDescription() {
        StringElement element = (StringElement)this.getExtension(OpenSearchConstants.DESCRIPTION);
        return element.getValue();
    }

    public void setTags(String ... tags) {
        if (tags != null && tags.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < tags.length - 1; ++i) {
                builder.append(tags[i]).append(" ");
            }
            builder.append(tags[tags.length - 1]);
            this.setExtensionStringValue(OpenSearchConstants.TAGS, builder.toString());
        } else {
            this.setExtensionStringValue(OpenSearchConstants.TAGS, "");
        }
    }

    public String getTags() {
        StringElement element = (StringElement)this.getExtension(OpenSearchConstants.TAGS);
        return element.getValue();
    }

    public void addUrls(Url ... urls) {
        if (urls != null && urls.length > 0) {
            for (Url url : urls) {
                this.addExtension((Element)url);
            }
        }
    }

    public List<Url> getUrls() {
        return this.getExtensions(OpenSearchConstants.URL);
    }

    public void addQueries(Query ... queries) {
        if (queries != null && queries.length > 0) {
            for (Query query : queries) {
                this.addExtension((Element)query);
            }
        }
    }

    public List<Query> getQueries() {
        return this.getExtensions(OpenSearchConstants.QUERY);
    }

    private void setExtensionStringValue(QName extension, String value) {
        StringElement element = (StringElement)this.getExtension(extension);
        if (element == null) {
            element = (StringElement)this.addExtension(extension);
        }
        element.setValue(value);
    }
}

