/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.Serializer;
import org.apache.abdera.ext.serializer.impl.FOMSerializer;
import org.apache.abdera.model.Element;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializationContext
implements SerializationContext {
    private final Abdera abdera;
    private final StreamWriter streamWriter;
    private final Map<Class, Serializer> serializers = new HashMap<Class, Serializer>();

    protected AbstractSerializationContext(StreamWriter streamWriter) {
        this(new Abdera(), streamWriter);
    }

    protected AbstractSerializationContext(Abdera abdera, StreamWriter streamWriter) {
        this.abdera = abdera;
        this.streamWriter = streamWriter;
        this.setSerializer((Class)Element.class, (Serializer)new FOMSerializer());
    }

    @Override
    public StreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    @Override
    public Abdera getAbdera() {
        return this.abdera;
    }

    @Override
    public Serializer getSerializer(ObjectContext objectContext) {
        try {
            Class type = objectContext.getObjectType();
            Serializer serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = objectContext.getSerializer();
            }
            if (serializer == null) {
                Annotation[] annotationArray = objectContext.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    serializer = this.serializers.get(annotation.annotationType());
                    if (serializer != null) {
                        return serializer;
                    }
                    ++n2;
                }
            }
            if (serializer == null && !type.isAnnotation()) {
                for (Class knownType : this.serializers.keySet()) {
                    if (knownType.isAnnotation() || !knownType.isAssignableFrom(type)) continue;
                    return this.serializers.get(knownType);
                }
            }
            return serializer;
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public boolean hasSerializer(ObjectContext objectContext) {
        return this.getSerializer(objectContext) != null;
    }

    @Override
    public boolean hasSerializer(Object object) {
        return this.hasSerializer(new ObjectContext(object));
    }

    @Override
    public boolean hasSerializer(Object object, Object parent, AccessibleObject accessor) {
        return this.hasSerializer(new ObjectContext(object, parent, accessor));
    }

    @Override
    public boolean hasSerializer(Class<?> type) {
        if (this.serializers.containsKey(type)) {
            return true;
        }
        if (!type.isAnnotation()) {
            for (Class t : this.serializers.keySet()) {
                if (t.isAnnotation() || !t.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSerializer(AccessibleObject accessor) {
        Class<? extends Object> returnType = AbstractSerializationContext.getReturnType(accessor);
        org.apache.abdera.ext.serializer.annotation.Serializer serializer = accessor.getAnnotation(org.apache.abdera.ext.serializer.annotation.Serializer.class);
        if (serializer != null && this.hasSerializer(serializer.value())) {
            return true;
        }
        return returnType != null && this.hasSerializer(returnType);
    }

    public void setSerializer(Class type, Serializer Serializer2) {
        this.serializers.put(type, Serializer2);
    }

    @Override
    public void serialize(Object object) {
        this.serialize(object, new ObjectContext(object));
    }

    @Override
    public void serialize(Object object, ObjectContext objectContext) {
        Serializer serializer;
        if (objectContext == null) {
            objectContext = new ObjectContext(object);
        }
        if ((serializer = this.getSerializer(objectContext)) == null) {
            throw new SerializationException("No Serializer available for " + objectContext.getObjectType());
        }
        this.serialize(object, objectContext, serializer);
    }

    @Override
    public void serialize(Object object, Serializer serializer) {
        this.serialize(object, new ObjectContext(object), serializer);
    }

    @Override
    public void serialize(Object object, ObjectContext objectContext, Serializer serializer) {
        Serializer overrideSerializer;
        if (objectContext == null) {
            objectContext = new ObjectContext(object);
        }
        if ((overrideSerializer = this.getSerializer(objectContext)) != null) {
            serializer = overrideSerializer;
        }
        if (serializer == null) {
            throw new SerializationException("No Serializer available for " + objectContext.getObjectType());
        }
        serializer.serialize(object, objectContext, this);
    }

    public static Class<? extends Object> getReturnType(AccessibleObject accessor) {
        if (accessor instanceof Field) {
            return ((Field)accessor).getType();
        }
        if (accessor instanceof Method) {
            return ((Method)accessor).getReturnType();
        }
        return null;
    }
}

