/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.abdera.ext.serializer.AbstractSerializationContext;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectContext {
    private final Class objectType;
    private final Object parent;
    private final AccessibleObject accessor;
    private final Annotation[] annotations;
    private final Serializer serializer;
    private final Field[] fields;
    private final Method[] methods;

    public ObjectContext(Object object) {
        this(object, null, null);
    }

    public ObjectContext(Object object, Object parent, AccessibleObject accessor) {
        this.objectType = object != null ? object.getClass() : (accessor != null ? AbstractSerializationContext.getReturnType(accessor) : null);
        this.parent = parent;
        this.accessor = accessor;
        this.annotations = this.initAnnotations();
        this.serializer = this.initSerializer();
        this.fields = this.initFields();
        this.methods = this.initMethods();
    }

    private Field[] initFields() {
        Field[] fields = this.objectType.getFields();
        ArrayList<Field> list = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods)) {
                list.add(field);
            }
            ++n2;
        }
        return list.toArray(new Field[list.size()]);
    }

    private Method[] initMethods() {
        Method[] methods = this.objectType.getMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            int mods = method.getModifiers();
            if (!Modifier.isStatic(mods) && !Modifier.isAbstract(mods) && method.getParameterTypes().length == 0 && method.getReturnType() != Void.class) {
                list.add(method);
            }
            ++n2;
        }
        return list.toArray(new Method[list.size()]);
    }

    private Annotation[] initAnnotations() {
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (this.objectType != null) {
            annotationArray = this.objectType.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                annotations.put(annotation.annotationType(), annotation);
                ++n;
            }
        }
        if (this.accessor != null) {
            annotationArray = this.accessor.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                annotations.put(annotation.annotationType(), annotation);
                ++n;
            }
        }
        return annotations.values().toArray(new Annotation[annotations.size()]);
    }

    private Serializer initSerializer() {
        try {
            org.apache.abdera.ext.serializer.annotation.Serializer ser = this.getAnnotation(org.apache.abdera.ext.serializer.annotation.Serializer.class);
            if (ser != null) {
                Class<? extends Serializer> serclass = ser.value();
                return serclass.newInstance();
            }
            return null;
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    public AccessibleObject getAccessor() {
        return this.accessor;
    }

    public Object getParent() {
        return this.parent;
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public <X extends Annotation> X getAnnotation(Class<X> annotationType) {
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == annotationType) {
                return (X)annotation;
            }
            ++n2;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public AccessibleObject[] getAccessors() {
        ArrayList<AccessibleObject> list = new ArrayList<AccessibleObject>();
        AccessibleObject[] accessibleObjectArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            list.add(method);
            ++n2;
        }
        accessibleObjectArray = this.fields;
        n = this.fields.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            list.add(field);
            ++n2;
        }
        return list.toArray(new AccessibleObject[list.size()]);
    }

    public AccessibleObject[] getAccessors(Class<? extends Annotation> annotation, Conventions conventions) {
        ArrayList<AccessibleObject> accessors = new ArrayList<AccessibleObject>();
        AccessibleObject[] accessibleObjectArray = this.getAccessors();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessibleObject accessor = accessibleObjectArray[n2];
            if (accessor.isAnnotationPresent(annotation) || annotation.equals(conventions.matchConvention(accessor))) {
                accessors.add(accessor);
            }
            ++n2;
        }
        return accessors.toArray(new AccessibleObject[accessors.size()]);
    }

    public AccessibleObject getAccessor(Class<? extends Annotation> annotation, Conventions conventions) {
        AccessibleObject[] accessibleObjectArray = this.getAccessors();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessibleObject accessor = accessibleObjectArray[n2];
            if (accessor.isAnnotationPresent(annotation) || annotation.equals(conventions.matchConvention(accessor))) {
                return accessor;
            }
            ++n2;
        }
        return null;
    }
}

