/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import javax.activation.DataHandler;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.annotation.Content;
import org.apache.abdera.ext.serializer.annotation.MediaType;
import org.apache.abdera.ext.serializer.annotation.Value;
import org.apache.abdera.ext.serializer.impl.ElementSerializer;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.util.Constants;
import org.apache.abdera.writer.StreamWriter;

public class ContentSerializer
extends ElementSerializer {
    public ContentSerializer() {
        super(Constants.CONTENT);
    }

    protected void init(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
    }

    protected void process(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        Content _content;
        Content.Type type = Content.Type.TEXT;
        Object contentValue = null;
        ObjectContext valueContext = null;
        AccessibleObject accessor = objectContext.getAccessor(Value.class, conventions);
        if (accessor != null && !(source instanceof Element)) {
            contentValue = ContentSerializer.eval(accessor, source);
            valueContext = new ObjectContext(contentValue, source, accessor);
            _content = valueContext.getAnnotation(Content.class);
            type = _content != null ? _content.type() : type;
        } else {
            _content = objectContext.getAnnotation(Content.class);
            type = _content != null ? _content.type() : type;
            contentValue = source;
            valueContext = objectContext;
        }
        StreamWriter sw = context.getStreamWriter();
        sw.startContent(type);
        this.writeAttributes(source, objectContext, context, conventions);
        if (type == Content.Type.MEDIA || type == Content.Type.XML) {
            String mediatype = null;
            AccessibleObject mtaccessor = valueContext.getAccessor(MediaType.class, conventions);
            if (mtaccessor != null) {
                Object mtvalue = ContentSerializer.eval(mtaccessor, contentValue);
                String string = mediatype = mtvalue != null ? ContentSerializer.toString(mtvalue) : null;
            }
            if (mediatype == null) {
                MediaType mt = valueContext.getAnnotation(MediaType.class);
                String string = mediatype = mt != null && !mt.value().equals("##default") ? mt.value() : null;
            }
            if (mediatype != null) {
                sw.writeAttribute("type", mediatype);
            }
        }
        switch (type) {
            case TEXT: 
            case HTML: {
                sw.writeElementText(ContentSerializer.toString(contentValue));
                break;
            }
            case XHTML: {
                Div div = null;
                if (contentValue instanceof Div) {
                    div = (Div)contentValue;
                } else {
                    div = context.getAbdera().getFactory().newDiv();
                    div.setValue(ContentSerializer.toString(contentValue));
                }
                context.serialize((Object)div, new ObjectContext(div));
                break;
            }
            case XML: {
                Element el = null;
                if (contentValue instanceof Element) {
                    el = (Element)contentValue;
                } else {
                    StringReader sr = new StringReader(ContentSerializer.toString(contentValue));
                    Document doc = context.getAbdera().getParser().parse((Reader)sr);
                    el = doc.getRoot();
                }
                context.serialize((Object)el, new ObjectContext(el));
                break;
            }
            case MEDIA: {
                try {
                    if (contentValue instanceof DataHandler) {
                        sw.writeElementText((DataHandler)contentValue);
                        break;
                    }
                    if (contentValue instanceof InputStream) {
                        sw.writeElementText((InputStream)contentValue);
                        break;
                    }
                    sw.writeElementText(ContentSerializer.toString(contentValue));
                    break;
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            }
        }
    }
}

