/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer.impl;

import java.lang.reflect.AccessibleObject;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.annotation.Value;
import org.apache.abdera.ext.serializer.impl.ElementSerializer;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.writer.StreamWriter;

public class DateTimeSerializer
extends ElementSerializer {
    public DateTimeSerializer(QName qname) {
        super(qname);
    }

    public DateTimeSerializer() {
        super(null);
    }

    protected void init(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        QName qname = this.qname != null ? this.qname : DateTimeSerializer.getQName(objectContext.getAccessor());
        StreamWriter sw = context.getStreamWriter();
        sw.startElement(qname);
    }

    protected void process(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        AccessibleObject accessor;
        this.writeAttributes(source, objectContext, context, conventions);
        Object value = null;
        if (!(source instanceof Long) && (accessor = objectContext.getAccessor(Value.class, conventions)) != null) {
            value = DateTimeSerializer.eval(accessor, source);
        }
        this.writeValue(value != null ? value : source, context);
    }

    private void writeValue(Object value, SerializationContext context) {
        StreamWriter sw = context.getStreamWriter();
        Date date = null;
        if (value == null) {
            return;
        }
        date = value instanceof Date ? (Date)value : (value instanceof Calendar ? ((Calendar)value).getTime() : (value instanceof Long ? new Date((Long)value) : (value instanceof String ? AtomDate.parse((String)((String)value)) : AtomDate.parse((String)value.toString()))));
        sw.writeElementText(date);
    }
}

