/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.wsse;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.RFC2617Scheme;

public class WSSEAuthScheme
extends RFC2617Scheme
implements AuthScheme {
    private final int NONCE_LENGTH = 16;

    public static void register(AbderaClient abderaClient, boolean exclusive) {
        AbderaClient.registerScheme((String)"WSSE", WSSEAuthScheme.class);
        if (exclusive) {
            abderaClient.setAuthenticationSchemePriority(new String[]{"WSSE"});
        } else {
            abderaClient.setAuthenticationSchemeDefaults();
        }
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials creds = (UsernamePasswordCredentials)credentials;
            AtomDate now = new AtomDate(new Date());
            String nonce = this.generateNonce();
            String digest = this.generatePasswordDigest(creds.getPassword(), nonce, now);
            String username = creds.getUserName();
            String wsse = "UsernameToken Username=\"" + username + "\", " + "PasswordDigest=\"" + digest + "\", " + "Nonce=\"" + nonce + "\", " + "Created=\"" + now.getValue() + "\"";
            if (method != null) {
                method.addRequestHeader("X-WSSE", wsse);
            }
            return "WSSE profile=\"UsernameToken\"";
        }
        return null;
    }

    private String generatePasswordDigest(String password, String nonce, AtomDate date) throws AuthenticationException {
        String temp = nonce + date.getValue() + password;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return new String(Base64.encodeBase64((byte[])md.digest(temp.getBytes())));
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private String generateNonce() throws AuthenticationException {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[16];
            sr.nextBytes(temp);
            String n = new String(Hex.encodeHex((byte[])temp));
            return n;
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return this.authenticate(credentials, null);
    }

    public String getSchemeName() {
        return "WSSE";
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isConnectionBased() {
        return false;
    }
}

