/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.jcr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Sanitizer;
import org.apache.abdera.jcr.SessionPoolManager;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.impl.AbstractCollectionProvider;
import org.apache.abdera.protocol.server.impl.AbstractResponseContext;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.ResponseContextException;
import org.apache.abdera.protocol.util.PoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrCollectionProvider
extends AbstractCollectionProvider<Node> {
    private static final Log log = LogFactory.getLog(JcrCollectionProvider.class);
    private static final String TITLE = "title";
    private static final String SUMMARY = "summary";
    private static final String UPDATED = "updated";
    private static final String AUTHOR = "author";
    private static final String AUTHOR_EMAIL = "author.email";
    private static final String AUTHOR_LANGUAGE = "author.language";
    private static final String AUTHOR_NAME = "author.name";
    private static final String CONTENT = "content";
    private static final String SESSION_KEY = "jcrSession";
    private static final String MEDIA = "media";
    private static final String CONTENT_TYPE = "contentType";
    private static final String NAMESPACE = "http://abdera.apache.org";
    private String collectionNodePath;
    private String id;
    private String title;
    private String author;
    private String collectionNodeId;
    private Repository repository;
    private Credentials credentials;
    private int maxActiveSessions = 100;
    private PoolManager<Session> sessionPool;

    public void setCollectionNodePath(String collectionNodePath) {
        this.collectionNodePath = collectionNodePath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void initialize() throws Exception {
        Session session = this.repository.login(this.credentials);
        Node collectionNode = null;
        try {
            collectionNode = session.getRootNode().getNode(this.collectionNodePath);
        }
        catch (PathNotFoundException e) {
            collectionNode = session.getRootNode().addNode(this.collectionNodePath);
            collectionNode.addMixin("mix:referenceable");
            session.save();
        }
        this.collectionNodeId = collectionNode.getUUID();
        this.id = "urn:" + this.collectionNodeId;
        Workspace workspace = session.getWorkspace();
        try {
            workspace.getNamespaceRegistry().getPrefix(NAMESPACE);
        }
        catch (NamespaceException e) {
            workspace.getNamespaceRegistry().registerNamespace("abdera", NAMESPACE);
        }
        NodeTypeDef[] nodeTypes = NodeTypeReader.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/abdera/jcr/nodeTypes.xml"));
        NodeTypeManagerImpl ntmgr = (NodeTypeManagerImpl)workspace.getNodeTypeManager();
        NodeTypeRegistry ntreg = ntmgr.getNodeTypeRegistry();
        NodeTypeDef[] nodeTypeDefArray = nodeTypes;
        int n = nodeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeTypeDef ntd = nodeTypeDefArray[n2];
            if (!ntreg.isRegistered(ntd.getName())) {
                ntreg.registerNodeType(ntd);
            }
            ++n2;
        }
        session.logout();
        this.sessionPool = new SessionPoolManager(this.maxActiveSessions, this.repository, this.credentials);
    }

    public void begin(RequestContext request) throws ResponseContextException {
        super.begin(request);
        try {
            Session session = (Session)this.sessionPool.get((Request)request);
            request.setAttribute(RequestContext.Scope.REQUEST, SESSION_KEY, (Object)session);
        }
        catch (Exception e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public void end(RequestContext request, ResponseContext response) {
        Session session = this.getSession(request);
        if (session != null) {
            try {
                this.sessionPool.release((Object)session);
            }
            catch (Exception e) {
                log.warn((Object)"Could not return Session to pool!", (Throwable)e);
            }
        }
        super.end(request, response);
    }

    public String getContentType(Node entry) {
        return JcrCollectionProvider.getStringOrNull(entry, CONTENT_TYPE);
    }

    public boolean isMediaEntry(Node entry) throws ResponseContextException {
        try {
            return entry.hasProperty(MEDIA);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public Node createMediaEntry(MimeType mimeType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        if (slug == null) {
            throw new ResponseContextException("A slug header must be supplied.", 500);
        }
        Node n = this.createEntry(slug, null, null, new Date(), null, null, request);
        try {
            n.setProperty(MEDIA, inputStream);
            n.setProperty(CONTENT_TYPE, mimeType.toString());
            String summary = this.createSummaryForEntry(n);
            if (summary != null) {
                n.setProperty(SUMMARY, summary);
            }
            this.getSession(request).save();
            return n;
        }
        catch (RepositoryException e) {
            try {
                n.remove();
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    protected String createSummaryForEntry(Node n) {
        return null;
    }

    public Node createEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        Node entry = null;
        try {
            Session session = this.getSession(request);
            Node collectionNode = session.getNodeByUUID(this.collectionNodeId);
            String resourceName = Sanitizer.sanitize((String)title, (String)"-");
            entry = this.createEntry(title, summary, updated, authors, content, session, collectionNode, resourceName, 0);
            return entry;
        }
        catch (RepositoryException e) {
            try {
                if (entry != null) {
                    entry.remove();
                }
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    protected Node createEntry(String title, String summary, Date updated, List<Person> authors, Content content, Session session, Node collectionNode, String resourceName, int num) throws ResponseContextException, RepositoryException {
        try {
            String name = resourceName;
            if (num > 0) {
                name = String.valueOf(name) + "_" + num;
            }
            Node entry = collectionNode.addNode(name, "abdera:entry");
            entry.addMixin("mix:referenceable");
            this.mapEntryToNode(entry, title, summary, updated, authors, content, session);
            session.save();
            return entry;
        }
        catch (ItemExistsException e) {
            return this.createEntry(title, summary, updated, authors, content, session, collectionNode, resourceName, num++);
        }
    }

    private Node mapEntryToNode(Node entry, String title, String summary, Date updated, List<Person> authors, Content content, Session session) throws ResponseContextException, RepositoryException {
        if (title == null) {
            EmptyResponseContext ctx = new EmptyResponseContext(500);
            ctx.setStatusText("Entry title cannot be empty.");
            throw new ResponseContextException((AbstractResponseContext)ctx);
        }
        entry.setProperty(TITLE, title);
        if (summary != null) {
            entry.setProperty(SUMMARY, summary);
        }
        Calendar upCal = Calendar.getInstance();
        upCal.setTime(updated);
        entry.setProperty(UPDATED, upCal);
        if (authors != null) {
            for (Person p : authors) {
                Node addNode = entry.addNode(AUTHOR);
                addNode.setProperty(AUTHOR_EMAIL, p.getEmail());
                addNode.setProperty(AUTHOR_LANGUAGE, p.getLanguage());
                addNode.setProperty(AUTHOR_NAME, p.getName());
            }
        }
        if (content != null) {
            entry.setProperty(CONTENT, content.getText());
        }
        if (summary != null) {
            entry.setProperty(SUMMARY, summary);
        }
        return entry;
    }

    private Session getSession(RequestContext request) {
        return (Session)request.getAttribute(RequestContext.Scope.REQUEST, SESSION_KEY);
    }

    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        try {
            Session session = this.getSession(request);
            Node node = this.getNode(session, resourceName);
            node.remove();
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    private Node getNode(Session session, String resourceName) throws ResponseContextException, RepositoryException {
        try {
            return session.getNodeByUUID(this.collectionNodeId).getNode(resourceName);
        }
        catch (PathNotFoundException e) {
            throw new ResponseContextException(404);
        }
    }

    public static void dump(Node node) throws RepositoryException {
        System.out.println(node.getPath());
        if (node.getName().equals("jcr:system")) {
            return;
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                int i = 0;
                while (i < values.length) {
                    System.out.println(String.valueOf(property.getPath()) + " = " + values[i].getString());
                    ++i;
                }
                continue;
            }
            System.out.println(String.valueOf(property.getPath()) + " = " + property.getString());
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            JcrCollectionProvider.dump(nodes.nextNode());
        }
    }

    public String getAuthor() throws ResponseContextException {
        return this.author;
    }

    public List<Person> getAuthors(Node entry, RequestContext request) throws ResponseContextException {
        try {
            ArrayList<Person> authors = new ArrayList<Person>();
            NodeIterator nodes = entry.getNodes();
            while (nodes.hasNext()) {
                Node n = nodes.nextNode();
                if (!n.getName().equals(AUTHOR)) continue;
                Person author = request.getAbdera().getFactory().newAuthor();
                author.setName(JcrCollectionProvider.getStringOrNull(entry, AUTHOR_NAME));
                author.setEmail(JcrCollectionProvider.getStringOrNull(entry, AUTHOR_EMAIL));
                author.setLanguage(JcrCollectionProvider.getStringOrNull(entry, AUTHOR_LANGUAGE));
                authors.add(author);
            }
            return authors;
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public Object getContent(Node entry, RequestContext request) throws ResponseContextException {
        return JcrCollectionProvider.getStringOrNull(entry, CONTENT);
    }

    public Iterable<Node> getEntries(RequestContext request) throws ResponseContextException {
        ArrayList<Node> entries = new ArrayList<Node>();
        Session session = this.getSession(request);
        try {
            Node n = session.getNodeByUUID(this.collectionNodeId);
            NodeIterator nodes = n.getNodes();
            while (nodes.hasNext()) {
                entries.add(nodes.nextNode());
            }
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        return entries;
    }

    public Node getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        try {
            return this.getNode(this.getSession(request), resourceName);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getId(Node entry) throws ResponseContextException {
        try {
            return "urn:" + entry.getUUID();
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public String getMediaName(Node entry) throws ResponseContextException {
        return this.getName(entry);
    }

    public InputStream getMediaStream(Node entry) throws ResponseContextException {
        Value value;
        block4: {
            value = JcrCollectionProvider.getValueOrNull(entry, MEDIA);
            if (value != null) break block4;
            return null;
        }
        try {
            return value.getStream();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public String getName(Node entry) throws ResponseContextException {
        try {
            return entry.getName();
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public Text getSummary(Node entry, RequestContext request) {
        Text summary = request.getAbdera().getFactory().newSummary();
        summary.setText(JcrCollectionProvider.getStringOrNull(entry, SUMMARY));
        return summary;
    }

    public String getTitle(RequestContext request) {
        return this.title;
    }

    public String getTitle(Node entry) throws ResponseContextException {
        return JcrCollectionProvider.getStringOrNull(entry, TITLE);
    }

    public Date getUpdated(Node entry) throws ResponseContextException {
        return JcrCollectionProvider.getDateOrNull(entry, UPDATED).getTime();
    }

    public void updateEntry(Node entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        Session session = this.getSession(request);
        try {
            this.mapEntryToNode(entry, title, summary, updated, authors, content, session);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public static String getStringOrNull(Node node, String propName) {
        try {
            Value v = JcrCollectionProvider.getValueOrNull(node, propName);
            if (v != null) {
                return v.getString();
            }
        }
        catch (ValueFormatException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Calendar getDateOrNull(Node node, String propName) throws ResponseContextException {
        try {
            Value v = JcrCollectionProvider.getValueOrNull(node, propName);
            if (v != null) {
                return v.getDate();
            }
        }
        catch (ValueFormatException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        return null;
    }

    public static Value getValueOrNull(Node node, String propName) throws PathNotFoundException, RepositoryException {
        Property p = null;
        try {
            p = node.getProperty(propName);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setMaxActiveSessions(int maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }
}

