/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyHelper {
    public static void saveKeystore(KeyStore ks, String file, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        ks.store(new FileOutputStream(file), password.toCharArray());
    }

    public static KeyStore loadKeystore(String file, String pass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (in == null) {
            in = new FileInputStream(file);
        }
        ks.load(in, pass.toCharArray());
        return ks;
    }

    public static KeyStore loadKeystore(String type, String file, String pass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(type);
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (in == null) {
            in = new FileInputStream(file);
        }
        ks.load(in, pass.toCharArray());
        return ks;
    }

    public static <T extends Key> T getKey(KeyStore ks, String alias, String pass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return (T)ks.getKey(alias, pass.toCharArray());
    }

    public static <T extends Certificate> T getCertificate(KeyStore ks, String alias) throws KeyStoreException {
        return (T)ks.getCertificate(alias);
    }

    public static KeyPair generateKeyPair(String type, int size) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(type);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyGen.initialize(size, random);
        random.setSeed(System.currentTimeMillis());
        return keyGen.generateKeyPair();
    }

    public static KeyPair generateKeyPair(String type, int size, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(type, provider);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", provider);
        keyGen.initialize(size, random);
        random.setSeed(System.currentTimeMillis());
        return keyGen.generateKeyPair();
    }

    public static SecretKey generateSecretKey(String type, int size) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(type);
        keyGenerator.init(size);
        return keyGenerator.generateKey();
    }

    public static Key generateKey(String type) throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance(type);
        keygen.init(new SecureRandom());
        return keygen.generateKey();
    }

    public static SecretKey generateSecretKey(String type, int size, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(type, provider);
        keyGenerator.init(size);
        return keyGenerator.generateKey();
    }

    public static PublicKey generatePublicKey(String hex) {
        block3: {
            try {
                if (hex != null && hex.trim().length() != 0) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        byte[] data = Hex.decodeHex((char[])hex.toCharArray());
        X509EncodedKeySpec keyspec = new X509EncodedKeySpec(data);
        KeyFactory keyfactory = KeyFactory.getInstance("RSA");
        return keyfactory.generatePublic(keyspec);
    }
}

