/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.RequestContextWrapper;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;

public abstract class AbstractEncryptedRequestFilter
implements Filter {
    protected final List<String> methods = new ArrayList<String>();

    protected AbstractEncryptedRequestFilter() {
        this("POST", "PUT");
    }

    protected AbstractEncryptedRequestFilter(String ... methods) {
        String[] stringArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            this.methods.add(method);
            ++n2;
        }
        this.initProvider();
    }

    protected void initProvider() {
    }

    protected void addProvider(Provider provider) {
        if (Security.getProvider(provider.getName()) == null) {
            Security.addProvider(provider);
        }
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        this.bootstrap(request);
        String method = request.getMethod();
        if (this.methods.contains(method.toUpperCase())) {
            return chain.next((RequestContext)new DecryptingRequestContextWrapper(request));
        }
        return chain.next(request);
    }

    protected abstract void bootstrap(RequestContext var1);

    protected abstract Object initArg(RequestContext var1);

    protected abstract EncryptionOptions initEncryptionOptions(RequestContext var1, Encryption var2, Object var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DecryptingRequestContextWrapper
    extends RequestContextWrapper {
        public DecryptingRequestContextWrapper(RequestContext request) {
            super(request);
        }

        public <T extends Element> Document<T> getDocument(Parser parser, ParserOptions options) throws ParseException, IOException {
            Document doc = super.getDocument();
            try {
                AbderaSecurity security;
                Encryption enc;
                if (doc != null && (enc = (security = new AbderaSecurity(this.getAbdera())).getEncryption()).isEncrypted(doc)) {
                    Object arg = AbstractEncryptedRequestFilter.this.initArg(this.request);
                    EncryptionOptions encoptions = AbstractEncryptedRequestFilter.this.initEncryptionOptions(this.request, enc, arg);
                    doc = enc.decrypt(doc, encoptions);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return doc;
        }
    }
}

