/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.abdera.security.util.DHContext;
import org.apache.abdera.security.util.filters.AbstractEncryptedRequestFilter;

public class DHEncryptedRequestFilter
extends AbstractEncryptedRequestFilter {
    public DHEncryptedRequestFilter() {
    }

    public DHEncryptedRequestFilter(String ... methods) {
        super(methods);
    }

    public void bootstrap(RequestContext request) {
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        ResponseContext response = super.filter(request, chain);
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "OPTIONS".equalsIgnoreCase(method)) {
            DHContext context = (DHContext)request.getAttribute(RequestContext.Scope.SESSION, "dhcontext");
            if (context == null) {
                context = new DHContext();
                request.setAttribute(RequestContext.Scope.SESSION, "dhcontext", (Object)context);
            }
            response.setHeader("Accept-Encryption", (Object)context.getRequestString());
        }
        return response;
    }

    protected Object initArg(RequestContext request) {
        DHContext context = (DHContext)request.getAttribute(RequestContext.Scope.SESSION, "dhcontext");
        String dh = request.getHeader("Content-Encrypted");
        if (context != null && dh != null && dh.length() > 0) {
            try {
                context.setPublicKey(dh);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return context;
    }

    protected EncryptionOptions initEncryptionOptions(RequestContext request, Encryption encryption, Object arg) {
        EncryptionOptions options = null;
        if (arg != null && arg instanceof DHContext) {
            try {
                options = ((DHContext)arg).getEncryptionOptions(encryption);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return options;
    }
}

