/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.xmlsec;

import java.security.Key;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.abdera.security.SecurityException;
import org.apache.abdera.security.SecurityOptions;
import org.apache.abdera.security.util.EncryptionBase;
import org.apache.abdera.security.xmlsec.XmlEncryptionOptions;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Element;

public class XmlEncryption
extends EncryptionBase {
    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    public XmlEncryption() {
        super(new Abdera());
    }

    public XmlEncryption(Abdera abdera) {
        super(abdera);
    }

    public Document encrypt(Document doc, EncryptionOptions options) throws SecurityException {
        try {
            org.w3c.dom.Document dom = this.fomToDom(doc, (SecurityOptions)options);
            Key dek = options.getDataEncryptionKey();
            Key kek = options.getKeyEncryptionKey();
            String dalg = options.getDataCipherAlgorithm();
            String kalg = options.getKeyCipherAlgorithm();
            boolean includeki = options.includeKeyInfo();
            EncryptedKey enckey = null;
            XMLCipher xmlCipher = XMLCipher.getInstance((String)dalg);
            xmlCipher.init(1, dek);
            if (includeki && kek != null && dek != null) {
                XMLCipher keyCipher = XMLCipher.getInstance((String)kalg);
                keyCipher.init(3, kek);
                enckey = keyCipher.encryptKey(dom, dek);
                EncryptedData encdata = xmlCipher.getEncryptedData();
                KeyInfo keyInfo = new KeyInfo(dom);
                keyInfo.add(enckey);
                encdata.setKeyInfo(keyInfo);
            }
            dom = xmlCipher.doFinal(dom, dom.getDocumentElement(), false);
            return this.domToFom(dom, (SecurityOptions)options);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public Document decrypt(Document doc, EncryptionOptions options) throws SecurityException {
        if (!this.isEncrypted(doc)) {
            return null;
        }
        try {
            org.w3c.dom.Document dom = this.fomToDom(doc, (SecurityOptions)options);
            Key kek = options.getKeyEncryptionKey();
            Key dek = options.getDataEncryptionKey();
            Element element = dom.getDocumentElement();
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, dek);
            xmlCipher.setKEK(kek);
            dom = xmlCipher.doFinal(dom, element);
            return this.domToFom(dom, (SecurityOptions)options);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public EncryptionOptions getDefaultEncryptionOptions() {
        return new XmlEncryptionOptions(this.getAbdera());
    }
}

