/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTarget
implements Target {
    protected final TargetType type;
    protected final RequestContext context;

    public AbstractTarget(TargetType type, RequestContext context) {
        this.type = type;
        this.context = context;
    }

    @Override
    public String getIdentity() {
        return this.context.getUri().toString();
    }

    @Override
    public String getParameter(String name) {
        return this.context.getParameter(name);
    }

    @Override
    public String[] getParameterNames() {
        String[] pn = this.context.getParameterNames();
        return pn != null ? pn : new String[]{};
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.getParameterNames()).iterator();
    }

    @Override
    public TargetType getType() {
        return this.type;
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    public String toString() {
        return this.getType() + " - " + this.getIdentity();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTarget other = (AbstractTarget)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

