/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.protocol.server.CollectionProvider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.impl.BaseResponseContext;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.MediaResponseContext;
import org.apache.abdera.protocol.server.impl.ProviderSupport;
import org.apache.abdera.protocol.server.impl.ResponseContextException;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionProvider<T>
extends ProviderSupport
implements CollectionProvider {
    private static final Log log = LogFactory.getLog(AbstractCollectionProvider.class);
    private String baseMediaIri = "media/";

    @Override
    public ResponseContext createEntry(RequestContext request) {
        try {
            MimeType contentType = request.getContentType();
            if (this.isMediaType(contentType)) {
                return this.createMediaEntry(request);
            }
            return this.createNonMediaEntry(request);
        }
        catch (ParseException pe) {
            return new EmptyResponseContext(415);
        }
        catch (ClassCastException cce) {
            return new EmptyResponseContext(415);
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new EmptyResponseContext(500);
        }
    }

    protected boolean isMediaType(MimeType contentType) {
        String ctype;
        String string = ctype = contentType != null ? contentType.toString() : null;
        return ctype != null && !MimeTypeHelper.isAtom((String)ctype);
    }

    public abstract T createEntry(String var1, IRI var2, String var3, Date var4, List<Person> var5, Content var6, RequestContext var7) throws ResponseContextException;

    public T createMediaEntry(MimeType mimeType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext deleteEntry(RequestContext request) {
        String id = this.getEntryID(request);
        if (id != null) {
            try {
                this.deleteEntry(id, request);
            }
            catch (ResponseContextException e) {
                return this.createErrorResponse(e);
            }
            return new EmptyResponseContext(204);
        }
        return new EmptyResponseContext(404);
    }

    public abstract void deleteEntry(String var1, RequestContext var2) throws ResponseContextException;

    public abstract String getAuthor() throws ResponseContextException;

    public List<Person> getAuthors(T entry, RequestContext request) throws ResponseContextException {
        return null;
    }

    public String getBaseMediaIri() {
        return this.baseMediaIri;
    }

    public abstract Object getContent(T var1, RequestContext var2) throws ResponseContextException;

    public String getContentType(T entry) {
        throw new UnsupportedOperationException();
    }

    public abstract Iterable<T> getEntries(RequestContext var1) throws ResponseContextException;

    @Override
    public ResponseContext getEntry(RequestContext request, IRI entryBaseIri) {
        try {
            Entry entry = this.getEntryFromCollectionProvider(entryBaseIri, request);
            if (entry != null) {
                return this.buildGetEntryResponse(request, entry);
            }
            return new EmptyResponseContext(404);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    protected ResponseContext buildGetEntryResponse(RequestContext request, Entry entry) {
        Feed feed = this.createFeedBase(request);
        entry.setSource(feed.getAsSource());
        Document entry_doc = entry.getDocument();
        BaseResponseContext<Document> rc = new BaseResponseContext<Document>(entry_doc);
        rc.setEntityTag(this.calculateEntityTag((Base)entry));
        return rc;
    }

    public abstract T getEntry(String var1, RequestContext var2) throws ResponseContextException;

    @Override
    public ResponseContext getFeed(RequestContext request) {
        Feed feed = this.createFeedBase(request);
        return this.getFeed(feed, request);
    }

    @Override
    public ResponseContext getFeed(Feed feed, RequestContext request) {
        try {
            this.addFeedDetails(feed, request);
            return this.buildGetFeedResponse(feed);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        feed.setUpdated(new Date());
        IRI baseIri = this.resolveBase(request);
        IRI entryIri = this.getEntryBaseFromFeedIRI(baseIri);
        Iterable<T> entries = this.getEntries(request);
        if (entries != null) {
            for (T entryObj : entries) {
                Entry e = feed.addEntry();
                this.addEntryDetails(request, e, entryIri, entryObj);
                if (this.isMediaEntry(entryObj)) {
                    this.addMediaContent(entryIri, e, entryObj);
                    continue;
                }
                this.addContent(e, entryObj, request);
            }
        }
    }

    protected ResponseContext buildGetFeedResponse(Feed feed) {
        Document document = feed.getDocument();
        BaseResponseContext<Document> rc = new BaseResponseContext<Document>(document);
        rc.setEntityTag(this.calculateEntityTag((Base)document.getRoot()));
        return rc;
    }

    protected ResponseContext createErrorResponse(ResponseContextException e) {
        if (log.isInfoEnabled()) {
            log.info((Object)"A ResponseException was thrown.", (Throwable)e);
        } else if (e.getResponseContext() instanceof EmptyResponseContext && ((EmptyResponseContext)e.getResponseContext()).getStatus() >= 500) {
            log.warn((Object)"A ResponseException was thrown.", (Throwable)e);
        }
        return e.getResponseContext();
    }

    public abstract String getId();

    public abstract String getId(T var1) throws ResponseContextException;

    @Override
    public ResponseContext getMedia(RequestContext request) {
        try {
            String id = this.getEntryID(request);
            T entryObj = this.getEntry(id, request);
            if (entryObj == null) {
                return new EmptyResponseContext(404);
            }
            return this.buildGetMediaResponse(entryObj);
        }
        catch (ParseException pe) {
            return new EmptyResponseContext(415);
        }
        catch (ClassCastException cce) {
            return new EmptyResponseContext(415);
        }
        catch (ResponseContextException e) {
            return e.getResponseContext();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new EmptyResponseContext(400);
        }
    }

    protected ResponseContext buildGetMediaResponse(T entryObj) throws ResponseContextException {
        MediaResponseContext ctx = new MediaResponseContext(this.getMediaStream(entryObj), this.getUpdated(entryObj), 200);
        ctx.setContentType(this.getContentType(entryObj));
        return ctx;
    }

    public String getMediaName(T entry) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    public InputStream getMediaStream(T entry) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    public abstract String getName(T var1) throws ResponseContextException;

    @Override
    public abstract String getTitle(RequestContext var1);

    public abstract String getTitle(T var1) throws ResponseContextException;

    public abstract Date getUpdated(T var1) throws ResponseContextException;

    public boolean isMediaEntry(T entry) throws ResponseContextException {
        return false;
    }

    public void setBaseMediaIri(String baseMediaIri) {
        this.baseMediaIri = baseMediaIri;
    }

    @Override
    public ResponseContext updateEntry(RequestContext request, IRI feedIri) {
        try {
            String id = this.getEntryID(request);
            T entryObj = this.getEntry(id, request);
            if (entryObj == null) {
                return new EmptyResponseContext(404);
            }
            Entry orig_entry = this.getEntryFromCollectionProvider(entryObj, feedIri, request);
            if (orig_entry != null) {
                MimeType contentType = request.getContentType();
                if (contentType != null && !MimeTypeHelper.isAtom((String)contentType.toString())) {
                    return new EmptyResponseContext(415);
                }
                Entry entry = this.getEntryFromRequest(request);
                if (entry != null) {
                    if (!entry.getId().equals((Object)orig_entry.getId())) {
                        return new EmptyResponseContext(409);
                    }
                    if (!AbstractCollectionProvider.isValidEntry(entry)) {
                        return new EmptyResponseContext(400);
                    }
                    this.updateEntry(entryObj, entry.getTitle(), new Date(), entry.getAuthors(), entry.getSummary(), entry.getContentElement(), request);
                    return new EmptyResponseContext(204);
                }
                return new EmptyResponseContext(400);
            }
            return new EmptyResponseContext(404);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
        catch (ParseException pe) {
            return new EmptyResponseContext(415);
        }
        catch (ClassCastException cce) {
            return new EmptyResponseContext(415);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new EmptyResponseContext(400);
        }
    }

    public abstract void updateEntry(T var1, String var2, Date var3, List<Person> var4, String var5, Content var6, RequestContext var7) throws ResponseContextException;

    protected void addContent(Entry e, T doc, RequestContext request) throws ResponseContextException {
        Object content = this.getContent(doc, request);
        if (content instanceof Content) {
            e.setContentElement((Content)content);
        } else if (content instanceof String) {
            e.setContent((String)content);
        }
    }

    protected void addEntryDetails(RequestContext request, Entry e, IRI entryBaseIri, T entryObj) throws ResponseContextException {
        Text t;
        IRI entryIri = entryBaseIri.resolve(this.getName(entryObj));
        e.addLink(entryIri.toString(), "edit");
        e.setId(this.getId(entryObj));
        e.setTitle(this.getTitle(entryObj));
        e.setUpdated(this.getUpdated(entryObj));
        List<Person> authors = this.getAuthors(entryObj, request);
        if (authors != null) {
            for (Person a : authors) {
                e.addAuthor(a);
            }
        }
        if ((t = this.getSummary(entryObj, request)) != null) {
            e.setSummaryElement(t);
        }
    }

    public Text getSummary(T entry, RequestContext request) throws ResponseContextException {
        return null;
    }

    protected void addMediaContent(IRI entryBaseIri, Entry entry, T doc) throws ResponseContextException {
        String name = this.getMediaName(doc);
        IRI mediaIri = this.getMediaIRI(entryBaseIri, name);
        mediaIri = entryBaseIri.resolve(mediaIri);
        entry.setContent(mediaIri, this.getContentType(doc));
        entry.addLink(mediaIri.toString(), "edit-media");
    }

    protected EntityTag calculateEntityTag(Base base) {
        String id = null;
        String modified = null;
        if (base instanceof Entry) {
            id = ((Entry)base).getId().toString();
            modified = ((Entry)base).getUpdatedElement().getText();
        } else if (base instanceof Feed) {
            id = ((Feed)base).getId().toString();
            modified = ((Feed)base).getUpdatedElement().getText();
        }
        return EntityTag.generate((String[])new String[]{id, modified});
    }

    protected Feed createFeedBase(RequestContext request) {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        try {
            feed.setId(this.getId());
            feed.setTitle(this.getTitle(request));
            feed.addLink("");
            feed.addLink("", "self");
            feed.addAuthor(this.getAuthor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return feed;
    }

    protected ResponseContext createMediaEntry(RequestContext request) {
        try {
            T doc = this.createMediaEntry(request.getContentType(), request.getSlug(), request.getInputStream(), request);
            IRI baseIri = this.resolveBase(request);
            IRI entryIri = this.getEntryBaseFromFeedIRI(baseIri);
            Entry entry = request.getAbdera().getFactory().newEntry();
            this.addEntryDetails(request, entry, entryIri, doc);
            this.addMediaContent(entryIri, entry, doc);
            return this.buildCreateMediaEntryResponse(entryIri, entry);
        }
        catch (IOException e) {
            return new EmptyResponseContext(500);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    protected ResponseContext buildCreateMediaEntryResponse(IRI entryIri, Entry entry) {
        return this.buildCreateEntryResponse(entryIri, entry);
    }

    protected ResponseContext buildCreateEntryResponse(IRI entryIri, Entry entry) {
        BaseResponseContext<Entry> rc = new BaseResponseContext<Entry>(entry);
        rc.setLocation(entryIri.resolve(entry.getEditLinkResolvedHref()).toString());
        rc.setContentLocation(rc.getLocation().toString());
        rc.setEntityTag(this.calculateEntityTag((Base)entry));
        rc.setStatus(201);
        return rc;
    }

    protected ResponseContext createNonMediaEntry(RequestContext request) throws IOException {
        Entry entry = this.getEntryFromRequest(request);
        if (entry != null) {
            if (!AbstractCollectionProvider.isValidEntry(entry)) {
                return new EmptyResponseContext(400);
            }
            entry.setUpdated(new Date());
            try {
                T entryObj = this.createEntry(entry.getTitle(), entry.getId(), entry.getSummary(), entry.getUpdated(), entry.getAuthors(), entry.getContentElement(), request);
                entry.getIdElement().setValue(this.getId(entryObj));
                IRI entryBaseUri = this.getEntryBaseFromFeedIRI(this.resolveBase(request));
                IRI entryIri = entryBaseUri.resolve(this.getName(entryObj));
                entry.addLink(entryIri.toString(), "edit");
                return this.buildCreateEntryResponse(entryIri, entry);
            }
            catch (ResponseContextException e) {
                return this.createErrorResponse(e);
            }
        }
        return new EmptyResponseContext(400);
    }

    protected IRI getEntryBaseFromFeedIRI(IRI baseIri) {
        return new IRI(String.valueOf(baseIri.toString()) + "/");
    }

    protected Entry getEntryFromCollectionProvider(IRI feedIri, RequestContext request) throws ResponseContextException {
        String id = this.getEntryID(request);
        T entryObj = this.getEntry(id, request);
        if (entryObj == null) {
            return null;
        }
        return this.getEntryFromCollectionProvider(entryObj, feedIri, request);
    }

    private Entry getEntryFromCollectionProvider(T entryObj, IRI feedIri, RequestContext request) throws ResponseContextException {
        Abdera abdera = request.getAbdera();
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        return this.buildEntry(entryObj, entry, feedIri, request);
    }

    private Entry buildEntry(T entryObj, Entry entry, IRI feedIri, RequestContext request) throws ResponseContextException {
        this.addEntryDetails(request, entry, feedIri, entryObj);
        if (this.isMediaEntry(entryObj)) {
            this.addMediaContent(feedIri, entry, entryObj);
        } else {
            this.addContent(entry, entryObj, request);
        }
        return entry;
    }

    protected Entry getEntryFromRequest(RequestContext request) throws IOException {
        Abdera abdera = request.getAbdera();
        Parser parser = abdera.getParser();
        Document entry_doc = (Document)request.getDocument(parser).clone();
        if (entry_doc == null) {
            return null;
        }
        return (Entry)entry_doc.getRoot();
    }

    protected String getEntryID(RequestContext request) {
        String path = request.getTargetPath();
        int q = path.indexOf("?");
        if (q != -1) {
            path = path.substring(0, q);
        }
        String[] segments = path.split("/");
        String id = segments[segments.length - 1];
        return UrlEncoding.decode((String)id);
    }

    protected IRI getMediaIRI(IRI entryBaseIri, String name) {
        return entryBaseIri.resolve(this.getBaseMediaIri()).resolve(name);
    }

    @Override
    protected IRI resolveBase(RequestContext request) {
        IRI uri = request.getUri();
        String q = uri.getQuery();
        if (q != null && !"".equals(q)) {
            String iriStr = uri.toString();
            int idx = iriStr.indexOf(63);
            uri = new IRI(iriStr.substring(0, idx));
        }
        IRI resolved = request.getBaseUri().resolve(uri);
        return resolved;
    }

    @Override
    public void begin(RequestContext request) throws ResponseContextException {
    }

    @Override
    public void end(RequestContext request, ResponseContext response) {
    }
}

