/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.util.Date;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.ProviderSupport;
import org.apache.abdera.protocol.server.impl.StreamWriterResponseContext;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractProvider
extends ProviderSupport
implements Provider {
    private static final Log log = LogFactory.getLog(AbstractProvider.class);
    protected int defaultpagesize = 10;

    protected AbstractProvider() {
    }

    protected AbstractProvider(int defaultpagesize) {
        this.defaultpagesize = defaultpagesize;
    }

    public ResponseContext request(RequestContext request) {
        TargetType type = request.getTarget().getType();
        String method = request.getMethod();
        log.debug((Object)Localizer.sprintf((String)"TARGET.TYPE", (Object[])new Object[]{type}));
        log.debug((Object)Localizer.sprintf((String)"TARGET.ID", (Object[])new Object[]{request.getTarget().getIdentity()}));
        log.debug((Object)Localizer.sprintf((String)"METHOD", (Object[])new Object[]{method}));
        if (method.equals("GET")) {
            if (type == TargetType.TYPE_SERVICE) {
                return this.getService(request);
            }
            if (type == TargetType.TYPE_COLLECTION) {
                return this.getFeed(request);
            }
            if (type == TargetType.TYPE_ENTRY) {
                return this.getEntry(request);
            }
            if (type == TargetType.TYPE_MEDIA) {
                return this.getMedia(request);
            }
            if (type == TargetType.TYPE_CATEGORIES) {
                return this.getCategories(request);
            }
        } else if (method.equals("HEAD")) {
            if (type == TargetType.TYPE_SERVICE) {
                return this.getService(request);
            }
            if (type == TargetType.TYPE_COLLECTION) {
                return this.getFeed(request);
            }
            if (type == TargetType.TYPE_ENTRY) {
                return this.getEntry(request);
            }
            if (type == TargetType.TYPE_MEDIA) {
                return this.getMedia(request);
            }
            if (type == TargetType.TYPE_CATEGORIES) {
                return this.getCategories(request);
            }
        } else if (method.equals("POST")) {
            if (type == TargetType.TYPE_COLLECTION) {
                return this.createEntry(request);
            }
            if (type == TargetType.TYPE_ENTRY) {
                return this.entryPost(request);
            }
            if (type == TargetType.TYPE_MEDIA) {
                return this.mediaPost(request);
            }
        } else if (method.equals("PUT")) {
            if (type == TargetType.TYPE_ENTRY) {
                return this.updateEntry(request);
            }
            if (type == TargetType.TYPE_MEDIA) {
                return this.updateMedia(request);
            }
        } else if (method.equals("DELETE")) {
            if (type == TargetType.TYPE_ENTRY) {
                return this.deleteEntry(request);
            }
            if (type == TargetType.TYPE_MEDIA) {
                return this.deleteMedia(request);
            }
        } else if (method.equals("OPTIONS")) {
            EmptyResponseContext rc = new EmptyResponseContext(200);
            rc.addHeader("Allow", this.combine(this.getAllowedMethods(type)));
            return rc;
        }
        return this.notallowed(request.getAbdera(), request, Localizer.get((String)"NOT.ALLOWED"), this.getAllowedMethods(request.getTarget().getType()));
    }

    public String[] getAllowedMethods(TargetType type) {
        if (type == null) {
            return new String[0];
        }
        if (type == TargetType.TYPE_COLLECTION) {
            return new String[]{"GET", "POST", "HEAD", "OPTIONS"};
        }
        if (type == TargetType.TYPE_CATEGORIES) {
            return new String[]{"GET", "HEAD", "OPTIONS"};
        }
        if (type == TargetType.TYPE_ENTRY) {
            return new String[]{"GET", "DELETE", "PUT", "POST", "HEAD", "OPTIONS"};
        }
        if (type == TargetType.TYPE_MEDIA) {
            return new String[]{"GET", "DELETE", "PUT", "POST", "HEAD", "OPTIONS"};
        }
        if (type == TargetType.TYPE_SERVICE) {
            return new String[]{"GET", "HEAD", "OPTIONS"};
        }
        return new String[]{"GET", "HEAD", "OPTIONS"};
    }

    protected String combine(String ... vals) {
        StringBuilder buf = new StringBuilder();
        for (String val : vals) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public ResponseContext entryPost(RequestContext request) {
        return this.notallowed(request.getAbdera(), request, Localizer.get((String)"NOT.ALLOWED"), this.getAllowedMethods(request.getTarget().getType()));
    }

    public ResponseContext mediaPost(RequestContext request) {
        return this.notallowed(request.getAbdera(), request, Localizer.get((String)"NOT.ALLOWED"), this.getAllowedMethods(request.getTarget().getType()));
    }

    public ResponseContext getCategories(RequestContext request) {
        StreamWriterResponseContext rc = new StreamWriterResponseContext(request.getAbdera()){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startCategories().endCategories().endDocument();
            }
        };
        rc.setStatus(200);
        rc.setLastModified(new Date());
        return rc;
    }

    public ResponseContext deleteMedia(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    public ResponseContext getMedia(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    public ResponseContext updateMedia(RequestContext request) {
        throw new UnsupportedOperationException();
    }
}

