/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ServiceContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.util.AbstractRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestContext
extends AbstractRequest
implements RequestContext {
    private static final Log log = LogFactory.getLog(AbstractRequestContext.class);
    protected final ServiceContext context;
    protected Subject subject;
    protected Principal principal;
    protected Target target;
    protected final String method;
    protected final IRI requestUri;
    protected final IRI baseUri;
    protected Document document;

    protected AbstractRequestContext(ServiceContext context, String method, IRI requestUri, IRI baseUri) {
        this.context = context;
        this.method = method;
        this.baseUri = baseUri;
        this.requestUri = requestUri;
    }

    @Override
    public Abdera getAbdera() {
        return this.context.getAbdera();
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument() throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (this.document == null) {
            Abdera abdera = this.context.getAbdera();
            Parser parser = abdera.getParser();
            this.document = this.getDocument(parser);
        }
        return this.document;
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument(Parser parser) throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (this.document == null) {
            ParserOptions options = parser.getDefaultParserOptions();
            this.document = this.getDocument(parser, options);
        }
        return this.document;
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument(ParserOptions options) throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (this.document == null) {
            Abdera abdera = this.context.getAbdera();
            Parser parser = abdera.getParser();
            this.document = this.getDocument(parser, options);
        }
        return this.document;
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument(Parser parser, ParserOptions options) throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (this.document == null) {
            return parser.parse(this.getInputStream(), null, options);
        }
        return this.document;
    }

    @Override
    public IRI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public IRI getResolvedUri() {
        return this.baseUri.resolve(this.getUri());
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public IRI getUri() {
        return this.requestUri;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.context;
    }

    @Override
    public String getTargetPath() {
        String uri = this.getUri().toString();
        String cpath = this.getContextPath();
        return cpath == null ? uri : uri.substring(cpath.length());
    }
}

