/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Filter;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionProvider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.AbstractCollectionProvider;
import org.apache.abdera.protocol.server.impl.AbstractProvider;
import org.apache.abdera.protocol.server.impl.AbstractResponseContext;
import org.apache.abdera.protocol.server.impl.DefaultTarget;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.ResponseContextException;
import org.apache.abdera.protocol.server.impl.StreamWriterResponseContext;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceProvider
extends AbstractProvider
implements Resolver<Target> {
    private static final Log log = LogFactory.getLog(AbstractServiceProvider.class);
    public static final String COLLECTION_PROVIDER_ATTRIBUTE = "collectionProvider";
    private String servicesPath = "/";

    protected AbstractServiceProvider(int count) {
        super(count);
    }

    public Target resolve(Request request) {
        RequestContext context = (RequestContext)request;
        String uri = context.getTargetPath();
        if (this.servicesPath == null) {
            throw new RuntimeException("You must set the servicesPath property on the ServiceProvider.");
        }
        TargetType tt = null;
        if (uri.equals(this.servicesPath)) {
            tt = TargetType.TYPE_SERVICE;
        } else if (uri.startsWith(this.servicesPath)) {
            String path = uri.substring(this.servicesPath.length());
            int q = path.indexOf("?");
            if (q != -1) {
                path = path.substring(0, q);
            }
            path = UrlEncoding.decode((String)path);
            CollectionProvider provider = null;
            String providerHref = null;
            block0: for (WorkspaceInfo wi : this.getWorkspaces()) {
                for (Map.Entry<String, CollectionProvider> e : wi.getCollectionProviders().entrySet()) {
                    if (!path.startsWith(e.getKey())) continue;
                    provider = e.getValue();
                    providerHref = e.getKey();
                    continue block0;
                }
            }
            if (provider != null) {
                context.setAttribute(RequestContext.Scope.REQUEST, COLLECTION_PROVIDER_ATTRIBUTE, provider);
                tt = providerHref.equals(path) ? TargetType.TYPE_COLLECTION : this.getOtherTargetType(context, path, providerHref, provider);
            }
        }
        if (tt == null) {
            tt = TargetType.TYPE_UNKNOWN;
        }
        return new DefaultTarget(tt, context);
    }

    protected TargetType getOtherTargetType(RequestContext context, String path, String providerHref, CollectionProvider provider) {
        String baseMedia = null;
        if (provider instanceof AbstractCollectionProvider) {
            baseMedia = ((AbstractCollectionProvider)provider).getBaseMediaIri();
        }
        if (providerHref.startsWith("/")) {
            providerHref = providerHref.substring(1);
        }
        if (providerHref.startsWith(baseMedia)) {
            return TargetType.TYPE_MEDIA;
        }
        return TargetType.TYPE_ENTRY;
    }

    @Override
    public ResponseContext getService(RequestContext request) {
        Abdera abdera = request.getAbdera();
        AbstractResponseContext rc = this.getServicesDocument(abdera, request);
        rc.setStatus(200);
        return rc;
    }

    private String getEncoding(RequestContext request) {
        return "utf-8";
    }

    private AbstractResponseContext getServicesDocument(Abdera abdera, final RequestContext request) {
        final String enc = this.getEncoding(request);
        return new StreamWriterResponseContext(abdera){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startService();
                for (WorkspaceInfo wp : AbstractServiceProvider.this.getWorkspaces()) {
                    sw.startWorkspace().writeTitle(wp.getName());
                    Set<Map.Entry<String, CollectionProvider>> entrySet = wp.getCollectionProviders().entrySet();
                    for (Map.Entry<String, CollectionProvider> entry : entrySet) {
                        String href;
                        CollectionProvider cp = entry.getValue();
                        try {
                            href = UrlEncoding.encode((CharSequence)entry.getKey(), (String)enc, (Filter[])new Filter[]{CharUtils.Profile.PATH.filter()});
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                        try {
                            sw.startCollection(href).writeTitle(cp.getTitle(request)).writeAcceptsEntry().endCollection();
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    sw.endWorkspace();
                }
                sw.endService().endDocument();
            }
        };
    }

    public abstract Collection<WorkspaceInfo> getWorkspaces();

    @Override
    public ResponseContext getFeed(RequestContext request) {
        CollectionProvider provider = null;
        ResponseContext res = null;
        try {
            provider = this.getCollectionProvider(request);
            provider.begin(request);
            ResponseContext responseContext = res = provider.getFeed(request);
            return responseContext;
        }
        catch (ResponseContextException e) {
            ResponseContext responseContext = res = this.createErrorResponse(e);
            return responseContext;
        }
        finally {
            this.end(provider, request, res);
        }
    }

    private CollectionProvider getCollectionProvider(RequestContext request) {
        return (CollectionProvider)request.getAttribute(RequestContext.Scope.REQUEST, COLLECTION_PROVIDER_ATTRIBUTE);
    }

    protected ResponseContext createErrorResponse(ResponseContextException e) {
        if (log.isInfoEnabled()) {
            log.info((Object)"A ResponseException was thrown.", (Throwable)e);
        } else if (e.getResponseContext() instanceof EmptyResponseContext && ((EmptyResponseContext)e.getResponseContext()).getStatus() >= 500) {
            log.warn((Object)"A ResponseException was thrown.", (Throwable)e);
        }
        return e.getResponseContext();
    }

    @Override
    public ResponseContext createEntry(RequestContext request) {
        CollectionProvider provider = null;
        ResponseContext response = null;
        try {
            provider = this.getCollectionProvider(request);
            provider.begin(request);
            ResponseContext responseContext = provider.createEntry(request);
            return responseContext;
        }
        catch (ResponseContextException e) {
            ResponseContext responseContext = response = this.createErrorResponse(e);
            return responseContext;
        }
        finally {
            this.end(provider, request, response);
        }
    }

    protected void end(CollectionProvider provider, RequestContext request, ResponseContext response) {
        if (provider != null) {
            try {
                provider.end(request, response);
            }
            catch (Throwable t) {
                log.warn((Object)"Could not end() CollectionProvider.", t);
            }
        }
    }

    @Override
    public ResponseContext getMedia(RequestContext request) {
        CollectionProvider provider = null;
        ResponseContext response = null;
        try {
            provider = this.getCollectionProvider(request);
            provider.begin(request);
            ResponseContext responseContext = provider.getMedia(request);
            return responseContext;
        }
        catch (ResponseContextException e) {
            ResponseContext responseContext = response = this.createErrorResponse(e);
            return responseContext;
        }
        finally {
            this.end(provider, request, response);
        }
    }

    @Override
    public ResponseContext updateMedia(RequestContext request) {
        return super.updateMedia(request);
    }

    @Override
    public ResponseContext deleteEntry(RequestContext request) {
        CollectionProvider provider = null;
        ResponseContext response = null;
        try {
            provider = this.getCollectionProvider(request);
            ResponseContext responseContext = provider.deleteEntry(request);
            return responseContext;
        }
        finally {
            this.end(provider, request, response);
        }
    }

    @Override
    public ResponseContext getEntry(RequestContext request) {
        CollectionProvider provider = null;
        ResponseContext response = null;
        try {
            IRI entryBaseIri = this.resolveBase(request).resolve("./");
            provider = this.getCollectionProvider(request);
            provider.begin(request);
            ResponseContext responseContext = provider.getEntry(request, entryBaseIri);
            this.end(provider, request, response);
            return responseContext;
        }
        catch (ResponseContextException e) {
            try {
                ResponseContext responseContext = response = this.createErrorResponse(e);
                this.end(provider, request, response);
                return responseContext;
            }
            catch (Throwable throwable) {
                this.end(provider, request, response);
                throw throwable;
            }
        }
    }

    @Override
    public ResponseContext updateEntry(RequestContext request) {
        CollectionProvider provider = null;
        ResponseContext response = null;
        try {
            IRI entryBaseIri = this.resolveBase(request).resolve("./");
            provider = this.getCollectionProvider(request);
            provider.begin(request);
            ResponseContext responseContext = provider.updateEntry(request, entryBaseIri);
            this.end(provider, request, response);
            return responseContext;
        }
        catch (ResponseContextException e) {
            try {
                ResponseContext responseContext = response = this.createErrorResponse(e);
                this.end(provider, request, response);
                return responseContext;
            }
            catch (Throwable throwable) {
                this.end(provider, request, response);
                throw throwable;
            }
        }
    }

    public String getServicesPath() {
        return this.servicesPath;
    }

    public void setServicesPath(String servicesPath) {
        this.servicesPath = servicesPath;
    }
}

