/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import javax.activation.MimeType;
import javax.servlet.ServletException;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.protocol.ItemManager;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.error.Error;
import org.apache.abdera.protocol.server.HttpResponse;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.RequestHandler;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.ServiceContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRequestHandler
implements RequestHandler {
    private static final Log log = LogFactory.getLog(DefaultRequestHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ServiceContext context, RequestContext request, HttpResponse response) throws IOException {
        Provider provider;
        ItemManager<Provider> manager;
        block9: {
            log.debug((Object)Localizer.get((String)"PROCESSING.REQUEST"));
            manager = context.getProviderManager();
            provider = (Provider)manager.get((Request)request);
            log.debug((Object)Localizer.sprintf((String)"USING.PROVIDER", (Object[])new Object[]{provider}));
            try {
                if (!this.preconditions(provider, request, response)) break block9;
                this.response(request, response, provider.request(request));
            }
            catch (Throwable e) {
                try {
                    log.error((Object)Localizer.get((String)"OUTPUT.ERROR"), e);
                    try {
                        this.response(request, response, new EmptyResponseContext(500));
                    }
                    catch (Exception ex) {
                        log.error((Object)Localizer.get((String)"OUTPUT.ERROR"), (Throwable)ex);
                        this.internalServerError(request, response);
                    }
                }
                catch (Throwable throwable) {
                    log.debug((Object)Localizer.sprintf((String)"RELEASING.PROVIDER", (Object[])new Object[]{provider}));
                    if (provider != null) {
                        manager.release((Object)provider);
                    }
                    throw throwable;
                }
                log.debug((Object)Localizer.sprintf((String)"RELEASING.PROVIDER", (Object[])new Object[]{provider}));
                if (provider != null) {
                    manager.release((Object)provider);
                }
            }
        }
        log.debug((Object)Localizer.sprintf((String)"RELEASING.PROVIDER", (Object[])new Object[]{provider}));
        if (provider != null) {
            manager.release((Object)provider);
        }
    }

    protected boolean preconditions(Provider provider, RequestContext request, HttpResponse response) throws IOException {
        if (provider == null) {
            this.noprovider(request, response);
            return false;
        }
        Target target = request.getTarget();
        if (target == null) {
            this.notfound(request, response);
            return false;
        }
        if (!this.checkMethod(provider, request)) {
            this.notallowed(request, response, request.getMethod(), provider.getAllowedMethods(target.getType()));
            return false;
        }
        return true;
    }

    protected void response(RequestContext request, HttpResponse response, ResponseContext context) throws IOException, ServletException {
        if (context != null) {
            String[] names;
            response.setStatus(context.getStatus());
            long cl = context.getContentLength();
            String cc = context.getCacheControl();
            if (cl > -1L) {
                response.setHeader("Content-Length", Long.toString(cl));
            }
            if (cc != null && cc.length() > 0) {
                response.setHeader("Cache-Control", cc);
            }
            try {
                MimeType ct = context.getContentType();
                if (ct != null) {
                    response.setContentType(ct.toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (String name : names = context.getHeaderNames()) {
                Object[] headers;
                for (Object value : headers = context.getHeaders(name)) {
                    if (value instanceof Date) {
                        response.setDateHeader(name, ((Date)value).getTime());
                        continue;
                    }
                    response.setHeader(name, value.toString());
                }
            }
            if (!request.getMethod().equals("HEAD") && context.hasEntity()) {
                OutputStream out = response.getOutputStream();
                context.writeTo(out);
                out.close();
            }
        } else {
            this.internalServerError(request, response);
        }
    }

    private void internalServerError(RequestContext request, HttpResponse response) throws UnsupportedEncodingException, IOException {
        this.sendError(request, response, 500, "There was an error fulfilling your request.");
    }

    private void sendError(RequestContext request, HttpResponse response, int code, String message) throws UnsupportedEncodingException, IOException {
        Abdera abdera = request.getAbdera();
        response.setStatus(code);
        response.setContentType("application/xml");
        StreamWriter sw = abdera.newStreamWriter().setOutputStream(response.getOutputStream(), "UTF-8");
        Error.create((StreamWriter)sw, (int)code, (String)message, null);
        sw.close();
    }

    protected boolean checkMethod(Provider provider, RequestContext context) throws IOException {
        String method = context.getMethod();
        Target target = context.getTarget();
        Object[] methods = provider.getAllowedMethods(target.getType());
        Arrays.sort(methods);
        return Arrays.binarySearch(methods, method) >= 0;
    }

    protected void noprovider(RequestContext request, HttpResponse response) throws IOException {
        this.sendError(request, response, 500, Localizer.get((String)"NO.PROVIDER"));
    }

    protected void notfound(RequestContext request, HttpResponse response) throws IOException {
        this.sendError(request, response, 404, Localizer.get((String)"NOT.FOUND"));
    }

    protected void notallowed(RequestContext request, HttpResponse response, String method, String[] methods) throws IOException {
        this.sendError(request, response, 405, Localizer.sprintf((String)"METHOD.NOT.ALLOWED", (Object[])new Object[]{method}));
        response.setHeader("Allow", this.combine(methods));
    }

    protected String combine(String ... vals) {
        StringBuilder buf = new StringBuilder();
        for (String val : vals) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(val);
        }
        return buf.toString();
    }
}

