/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.protocol.error.Error;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.impl.AbstractResponseContext;
import org.apache.abdera.protocol.server.impl.BaseResponseContext;
import org.apache.abdera.protocol.server.impl.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.StreamWriterResponseContext;
import org.apache.abdera.protocol.util.EncodingUtil;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderSupport {
    private static final Log log = LogFactory.getLog(ProviderSupport.class);
    protected int defaultpagesize = 10;

    protected ProviderSupport() {
    }

    protected ProviderSupport(int defaultpagesize) {
        this.defaultpagesize = defaultpagesize;
    }

    public int getDefaultpagesize() {
        return this.defaultpagesize;
    }

    public void setDefaultpagesize(int defaultpagesize) {
        this.defaultpagesize = defaultpagesize;
    }

    protected Document<Error> createErrorDocument(Abdera abdera, int code, String message, Throwable e) {
        Error error = Error.create((Abdera)abdera, (int)code, (String)message);
        return error.getDocument();
    }

    protected AbstractResponseContext createErrorResponse(Abdera abdera, int code, String message) {
        return this.createErrorResponse(abdera, code, message, null);
    }

    protected AbstractResponseContext createErrorResponse(Abdera abdera, final int code, final String message, final Throwable t) {
        StreamWriterResponseContext rc = new StreamWriterResponseContext(abdera){

            protected void writeTo(StreamWriter sw) throws IOException {
                Error.create((StreamWriter)sw, (int)code, (String)message, (Throwable)t);
            }
        };
        rc.setStatus(code);
        rc.setStatusText(message);
        return rc;
    }

    protected ResponseContext servererror(Abdera abdera, RequestContext request, String reason, Throwable t) {
        log.debug((Object)Localizer.get((String)"SERVER_ERROR"));
        return this.createErrorResponse(abdera, 500, reason, t);
    }

    protected ResponseContext unauthorized(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"UNAUTHORIZED"));
        return this.createErrorResponse(abdera, 401, reason);
    }

    protected ResponseContext forbidden(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"FORBIDDEN"));
        return this.createErrorResponse(abdera, 403, reason);
    }

    protected ResponseContext unknown(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"UNKNOWN"));
        return this.createErrorResponse(abdera, 404, reason);
    }

    protected ResponseContext notallowed(Abdera abdera, RequestContext request, String reason, String ... methods) {
        log.debug((Object)Localizer.get((String)"NOT.ALLOWED"));
        AbstractResponseContext resp = this.createErrorResponse(abdera, 405, reason);
        resp.setAllow(methods);
        return resp;
    }

    protected ResponseContext badrequest(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"BAD.REQUEST"));
        return this.createErrorResponse(abdera, 400, reason);
    }

    protected ResponseContext conflict(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"CONFLICT"));
        return this.createErrorResponse(abdera, 409, reason);
    }

    protected ResponseContext unavailable(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"UNAVAILABLE"));
        return this.createErrorResponse(abdera, 503, reason);
    }

    protected ResponseContext notmodified(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"NOT.MODIFIED"));
        return new EmptyResponseContext(304, reason);
    }

    protected ResponseContext preconditionfailed(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"PRECONDITION.FAILED"));
        return this.createErrorResponse(abdera, 412, reason);
    }

    protected ResponseContext notsupported(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"NOT.SUPPORTED"));
        return this.createErrorResponse(abdera, 415, reason);
    }

    protected ResponseContext locked(Abdera abdera, RequestContext request, String reason) {
        log.debug((Object)Localizer.get((String)"LOCKED"));
        return this.createErrorResponse(abdera, 423, reason);
    }

    protected ResponseContext returnBase(Base base, int status, Date lastModified) {
        Document doc;
        log.debug((Object)Localizer.get((String)"RETURNING.DOCUMENT"));
        BaseResponseContext<Base> response = new BaseResponseContext<Base>(base);
        response.setStatus(status);
        if (lastModified != null) {
            response.setLastModified(lastModified);
        }
        response.setContentType(MimeTypeHelper.getMimeType((Base)base));
        Document document = doc = base instanceof Document ? (Document)base : ((Element)base).getDocument();
        if (doc.getEntityTag() != null) {
            response.setEntityTag(doc.getEntityTag());
        } else if (doc.getLastModified() != null) {
            response.setLastModified(doc.getLastModified());
        }
        return response;
    }

    protected String sanitizeSlug(String slug) {
        if (slug == null) {
            throw new IllegalArgumentException(Localizer.get((String)"SLUG.NOT.NULL"));
        }
        String sanitized = EncodingUtil.sanitize((String)slug);
        log.debug((Object)Localizer.sprintf((String)"SLUG.SANITIZED", (Object[])new Object[]{slug, sanitized}));
        return sanitized;
    }

    protected int getDefaultPageSize() {
        log.debug((Object)Localizer.sprintf((String)"DEFAULT.PAGE.SIZE", (Object[])new Object[]{this.defaultpagesize}));
        return this.defaultpagesize;
    }

    protected int getPageSize(RequestContext request, String pagesizeparam) {
        int max;
        int size = max = this.getDefaultPageSize();
        try {
            String _ps = request.getParameter(pagesizeparam);
            size = _ps != null ? Math.min(Math.max(Integer.parseInt(_ps), 0), max) : max;
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug((Object)Localizer.sprintf((String)"PAGE.SIZE", (Object[])new Object[]{size}));
        return size;
    }

    protected int getOffset(RequestContext request, String pageparam, int pageSize) {
        int offset = 0;
        try {
            String _page = request.getParameter(pageparam);
            int page = _page != null ? Integer.parseInt(_page) : 1;
            page = Math.max(page, 1) - 1;
            offset = pageSize * page;
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug((Object)Localizer.sprintf((String)"OFFSET", (Object[])new Object[]{offset}));
        return offset;
    }

    protected static boolean isValidEntry(Entry entry) {
        Content content;
        block13: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            try {
                                IRI id = entry.getId();
                                if (id != null && id.toString().trim().length() != 0 && id.isAbsolute()) break block9;
                                return false;
                            }
                            catch (Exception e) {
                                log.debug((Object)Localizer.sprintf((String)"CHECKING.VALID.ENTRY", (Object[])new Object[]{false}));
                                return false;
                            }
                        }
                        if (entry.getTitle() != null) break block10;
                        return false;
                    }
                    if (entry.getUpdated() != null) break block11;
                    return false;
                }
                if (entry.getAuthor() != null || entry.getSource() == null || entry.getAuthor() != null) break block12;
                return false;
            }
            content = entry.getContentElement();
            if (content != null) break block13;
            if (entry.getAlternateLink() == null) {
                return false;
            }
        }
        if ((content.getSrc() != null || content.getContentType() == Content.Type.MEDIA || content.getContentType() == Content.Type.XML) && entry.getSummary() == null) {
            log.debug((Object)Localizer.sprintf((String)"CHECKING.VALID.ENTRY", (Object[])new Object[]{false}));
            return false;
        }
        log.debug((Object)Localizer.sprintf((String)"CHECKING.VALID.ENTRY", (Object[])new Object[]{true}));
        return true;
    }

    protected void checkEntryAddAdditionalNamespaces(List ignore) {
    }

    protected boolean checkEntryNamespaces(RequestContext request, Entry entry) {
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add("http://www.w3.org/2007/app");
        ignore.add("http://www.w3.org/1999/xhtml");
        ignore.add("http://www.w3.org/XML/1998/namespace");
        this.checkEntryAddAdditionalNamespaces(ignore);
        boolean answer = this.checkElement((Element)entry, ignore);
        log.debug((Object)Localizer.sprintf((String)"CHECKING.ENTRY.NAMESPACES", (Object[])new Object[]{answer}));
        return answer;
    }

    private boolean checkElement(Element element, List ignore) {
        List attrs = element.getExtensionAttributes();
        for (QName qname : attrs) {
            String ns = qname.getNamespaceURI();
            if (ignore.contains(ns)) continue;
            return false;
        }
        if (element instanceof ExtensibleElement) {
            ExtensibleElement ext = (ExtensibleElement)element;
            List extensions = ext.getExtensions();
            for (Element el : extensions) {
                QName qname = el.getQName();
                String ns = qname.getNamespaceURI();
                if (!ignore.contains(ns)) {
                    return false;
                }
                if (this.checkElement(el, ignore)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean beforeOrEqual(Date d1, Date d2) {
        long l2;
        long l1 = d1.getTime() / 1000L;
        return l1 <= (l2 = d2.getTime() / 1000L);
    }

    protected IRI resolveBase(RequestContext request) {
        return request.getBaseUri().resolve(request.getUri());
    }
}

