/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.DefaultTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexTargetResolver
implements Resolver<Target> {
    private final Map<Pattern, TargetType> patterns = new HashMap<Pattern, TargetType>();

    public RegexTargetResolver() {
    }

    public RegexTargetResolver(Map<String, TargetType> patterns) {
        for (String p : patterns.keySet()) {
            TargetType type = patterns.get(p);
            this.setPattern(p, type);
        }
    }

    public synchronized RegexTargetResolver setPattern(String pattern, TargetType type) {
        Pattern p = Pattern.compile(pattern);
        this.patterns.put(p, type);
        return this;
    }

    public Target resolve(Request request) {
        RequestContext context = (RequestContext)request;
        String uri = context.getTargetPath();
        for (Pattern pattern : this.patterns.keySet()) {
            Matcher matcher = pattern.matcher(uri);
            if (!matcher.matches()) continue;
            TargetType type = this.patterns.get(pattern);
            return this.getTarget(type, context, matcher);
        }
        return null;
    }

    protected Target getTarget(TargetType type, RequestContext request, Matcher matcher) {
        return new RegexTarget(type, request, matcher);
    }

    public static class RegexTarget
    extends DefaultTarget
    implements Target {
        private static final long serialVersionUID = 165211244926064449L;
        protected transient Matcher matcher;

        protected RegexTarget(TargetType type, RequestContext context, Matcher matcher) {
            super(type, context);
            this.matcher = matcher;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            String m = this.matcher.group(0);
            String p = this.matcher.pattern().pattern();
            result = 31 * result + super.hashCode();
            result = 31 * result + (m == null ? 0 : m.hashCode());
            result = 31 * result + (p == null ? 0 : p.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexTarget other = (RegexTarget)obj;
            String m = this.matcher.group(0);
            String p = this.matcher.pattern().pattern();
            String m2 = other.matcher.group(0);
            String p2 = other.matcher.pattern().pattern();
            if (!super.equals(obj)) {
                return false;
            }
            if (m == null ? m2 != null : !m.equals(m2)) {
                return false;
            }
            if (p == null ? p2 != null : !p.equals(p2)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            String[] params;
            String m = this.matcher.group(0);
            String p = this.matcher.pattern().pattern();
            StringBuilder buf = new StringBuilder();
            buf.append("RegexTarget[").append(p).append(" ==> ").append(m).append("] = ").append(this.type.toString()).append("\n");
            for (String param : params = this.getParameterNames()) {
                buf.append("    ").append(param).append(" = ").append(this.getParameter(param)).append("\n");
            }
            return buf.toString();
        }
    }
}

