/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.ItemManager;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.error.Error;
import org.apache.abdera.protocol.server.RequestHandler;
import org.apache.abdera.protocol.server.ServiceContext;
import org.apache.abdera.protocol.server.ServiceManager;
import org.apache.abdera.protocol.server.impl.HttpServletRequestContext;
import org.apache.abdera.protocol.server.servlet.HttpResponseServletAdapter;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbderaServlet
extends HttpServlet {
    private static final long serialVersionUID = 2393643907128535158L;
    private static final Log log = LogFactory.getLog(AbderaServlet.class);
    protected ServiceManager manager;
    protected ServiceContext context;

    public void init() throws ServletException {
        log.debug((Object)"Initialing Abdera Servlet");
        this.manager = this.createServiceManager();
        this.context = this.createServiceContext();
        if (this.context == null) {
            log.debug((Object)"Cannot create service context");
            throw new ServletException("Cannot create service context");
        }
    }

    public Abdera getAbdera() {
        return ServiceManager.getAbdera();
    }

    public ServiceContext getServiceContext() {
        return this.context;
    }

    public ServiceManager getServiceManager() {
        return this.manager;
    }

    protected ServiceContext createServiceContext() {
        return this.manager.newServiceContext(this.getProperties(this.getServletConfig()));
    }

    protected ServiceManager createServiceManager() {
        return ServiceManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequestContext reqcontext = new HttpServletRequestContext(this.context, request);
        ItemManager<RequestHandler> manager = this.context.getRequestHandlerManager();
        log.debug((Object)"Processing request");
        RequestHandler handler = (RequestHandler)manager.get((Request)reqcontext);
        log.debug((Object)("Handler - " + handler));
        try {
            handler.process(this.context, reqcontext, new HttpResponseServletAdapter(response));
        }
        catch (Throwable t) {
            this.error("Error servicing request", t, response);
            return;
        }
        finally {
            log.debug((Object)("Releasing handler - " + handler));
            manager.release((Object)handler);
        }
        log.debug((Object)"Request complete");
    }

    private void error(String message, Throwable t, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            response.reset();
        }
        if (t != null) {
            log.error((Object)message, t);
        } else {
            log.error((Object)message);
        }
        response.setStatus(500);
        StreamWriter sw = this.getAbdera().newStreamWriter().setOutputStream((OutputStream)response.getOutputStream(), "UTF-8");
        Error.create((StreamWriter)sw, (int)500, (String)message, (Throwable)t);
        sw.close();
    }

    protected Map<String, String> getProperties(ServletConfig config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = config.getInitParameter(key);
            properties.put(key, val);
        }
        return properties;
    }
}

