/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.abdera.i18n.text.io.RewindableInputStream;
import org.apache.abdera.util.CompressionUtil;

public abstract class AbstractFilter
implements Filter {
    private FilterConfig config;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    protected FilterConfig getConfig() {
        return this.config;
    }

    public static class BufferedRequestWrapper
    extends HttpServletRequestWrapper {
        private BufferedServletInputStream bin;
        private RewindableInputStream rin;
        private BufferedReader rdr;

        public BufferedRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public void setInputStream(InputStream in) {
            this.bin = new BufferedServletInputStream(in);
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.rdr != null) {
                throw new IllegalStateException();
            }
            if (this.bin == null) {
                this.rin = new RewindableInputStream((InputStream)super.getInputStream());
                this.bin = new BufferedServletInputStream((InputStream)this.rin);
            }
            return this.bin;
        }

        public BufferedReader getReader() throws IOException {
            if (this.rdr == null) {
                String charset = this.getCharacterEncoding();
                this.rdr = charset == null ? new BufferedReader(new InputStreamReader((InputStream)this.getInputStream())) : new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), charset));
            }
            return this.rdr;
        }

        public void reset() throws IOException {
            if (this.bin != null) {
                this.rin.rewind();
            }
            this.rdr = null;
        }
    }

    public static class BufferedServletInputStream
    extends ServletInputStream {
        private InputStream in;

        public BufferedServletInputStream(InputStream in) {
            this.in = in;
            try {
                in.mark(in.available());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int read() throws IOException {
            return this.in.read();
        }
    }

    public static class BufferingResponseWrapper
    extends HttpServletResponseWrapper {
        PrintWriter output = null;
        ServletOutputStream outStream = null;

        public BufferingResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() throws IOException {
            if (this.output == null) {
                this.output = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.output;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outStream == null) {
                this.outStream = new BufferingServletOutputStream();
            }
            return this.outStream;
        }

        public Reader getReader() throws IOException {
            return new InputStreamReader(this.getInputStream(), this.getCharacterEncoding());
        }

        public InputStream getInputStream() throws IOException {
            BufferingServletOutputStream out = (BufferingServletOutputStream)this.getOutputStream();
            return new ByteArrayInputStream(out.getBuffer().toByteArray());
        }
    }

    public static class BufferingServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        public ByteArrayOutputStream getBuffer() {
            return this.out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            this.out.close();
            super.close();
        }

        public void flush() throws IOException {
            this.out.flush();
            super.flush();
        }
    }

    public static class CompressingResponseWrapper
    extends HttpServletResponseWrapper {
        ServletOutputStream out = null;
        PrintWriter output = null;

        public CompressingResponseWrapper(HttpServletResponse response, CompressionUtil.CompressionCodec codec) throws IOException {
            super(response);
            this.out = new CompressingServletOutputStream(codec, response.getOutputStream());
        }

        public PrintWriter getWriter() throws IOException {
            if (this.output == null) {
                this.output = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.output;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.out;
        }

        public void finish() throws IOException {
            this.out.flush();
        }

        public static boolean canHandle(String enc) {
            return enc.equalsIgnoreCase("gzip") || enc.equalsIgnoreCase("compress");
        }
    }

    public static class CompressingServletOutputStream
    extends ServletOutputStream {
        private OutputStream dout;

        public CompressingServletOutputStream(CompressionUtil.CompressionCodec codec, ServletOutputStream out) {
            try {
                this.dout = CompressionUtil.getEncodedOutputStream((OutputStream)out, (CompressionUtil.CompressionCodec)codec);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public CompressingServletOutputStream(DeflaterOutputStream dout) {
            this.dout = dout;
        }

        public void write(int b) throws IOException {
            this.dout.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.dout.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.dout.write(b);
        }
    }
}

