/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.protocol.server.HttpResponse;

public class HttpResponseServletAdapter
implements HttpResponse {
    private HttpServletResponse response;

    public HttpResponseServletAdapter(HttpServletResponse response) {
        this.response = response;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public HttpResponse setContentType(String contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    public HttpResponse setDateHeader(String key, long time) {
        this.response.setDateHeader(key, time);
        return this;
    }

    public HttpResponse setHeader(String name, String value) {
        this.response.setHeader(name, value);
        return this;
    }

    public HttpResponse setStatus(int status) {
        this.response.setStatus(status);
        return this;
    }

    public HttpResponse addCookie(String name, String value) {
        return this.addCookie(name, value, null, null, -1, null);
    }

    public HttpResponse addCookie(String name, String value, String domain, String path, int maxage, String comment) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        if (maxage >= 0) {
            cookie.setMaxAge(maxage);
        }
        if (comment != null) {
            cookie.setComment(comment);
        }
        this.response.addCookie(cookie);
        return this;
    }

    public HttpResponse setCharacterEncoding(String charset) {
        this.response.setCharacterEncoding(charset);
        return this;
    }

    public HttpResponse setContentLength(int length) {
        this.response.setContentLength(length);
        return this;
    }

    public HttpResponse sendError(int status) throws IOException {
        this.response.sendError(status);
        return this;
    }

    public HttpResponse sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
        return this;
    }

    public HttpResponse sendRedirect(String to) throws IOException {
        this.response.sendRedirect(to);
        return this;
    }

    public HttpResponse reset() {
        this.response.reset();
        return this;
    }

    public HttpServletResponse getActual() {
        return this.response;
    }
}

