/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.protocol.server.servlet.AbstractFilter;

public class MethodOverrideFilter
extends AbstractFilter
implements Filter {
    public static final String METHODS = "org.apache.abdera.protocol.server.servlet.Overrides";
    private final List<String> METHODS_TO_OVERRIDE = new ArrayList<String>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)new MethodOverrideRequestWrapper((HttpServletRequest)request), response);
        HttpServletResponse hresponse = (HttpServletResponse)response;
        hresponse.setHeader("Cache-Control", "no-cache");
    }

    public void init(FilterConfig config) throws ServletException {
        String param = config.getInitParameter(METHODS);
        if (param != null) {
            String[] methods;
            String[] stringArray = methods = param.split(",");
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String method = stringArray[n2];
                method = method.trim();
                this.METHODS_TO_OVERRIDE.add(method);
                ++n2;
            }
        }
    }

    private class MethodOverrideRequestWrapper
    extends HttpServletRequestWrapper {
        private final String method;

        public MethodOverrideRequestWrapper(HttpServletRequest request) {
            super(request);
            String method = super.getMethod();
            String xheader = this.getHeader("X-HTTP-Method-Override");
            if (xheader == null) {
                xheader = this.getHeader("X-Method-Override");
            }
            if (xheader != null) {
                xheader = xheader.toUpperCase().trim();
            }
            if (method.equals("POST") && xheader != null && MethodOverrideFilter.this.METHODS_TO_OVERRIDE.contains(xheader)) {
                method = xheader;
            }
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

