/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.abdera.Abdera;
import org.apache.abdera.writer.NamedWriter;
import org.apache.abdera.writer.WriterFactory;

public class ServerUtils {
    public static String[] orderByQ(String header) {
        if (header == null || header.length() == 0) {
            return new String[0];
        }
        String[] tokens = header.split(",");
        QToken[] qtokens = new QToken[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            String[] qvalues = token.trim().split(";");
            String t = qvalues[0];
            if (qvalues.length > 1) {
                for (int n = 1; n < qvalues.length; ++n) {
                    String[] v = qvalues[n].trim().split("=");
                    if (!v[0].trim().equals("q")) continue;
                    double qv = Double.parseDouble(v[1]);
                    qtokens[i] = new QToken(t, qv);
                    break;
                }
            }
            if (qtokens[i] != null) continue;
            qtokens[i] = new QToken(t, 1.0);
        }
        Arrays.sort(qtokens, new QTokenComparator());
        tokens = new String[qtokens.length];
        for (int n = 0; n < qtokens.length; ++n) {
            tokens[n] = qtokens[n].token;
        }
        return tokens;
    }

    public static NamedWriter getAcceptableNamedWriter(Abdera abdera, String accept_header) {
        String[] sorted_accepts = ServerUtils.orderByQ(accept_header);
        WriterFactory factory = abdera.getWriterFactory();
        if (factory == null) {
            return null;
        }
        for (String accept : sorted_accepts) {
            NamedWriter writer = (NamedWriter)factory.getWriterByMediaType(accept);
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    public static NamedWriter getNamedWriter(Abdera abdera, String mediatype) {
        WriterFactory factory = abdera.getWriterFactory();
        if (factory == null) {
            return null;
        }
        NamedWriter writer = (NamedWriter)factory.getWriterByMediaType(mediatype);
        return writer;
    }

    private static class QToken {
        String token;
        double qvalue = 1.0;

        QToken(String token, double qvalue) {
            this.token = token;
            this.qvalue = qvalue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QTokenComparator
    implements Comparator<QToken> {
        private QTokenComparator() {
        }

        @Override
        public int compare(QToken o1, QToken o2) {
            if (o1.qvalue > o2.qvalue) {
                return -1;
            }
            if (o1.qvalue < o2.qvalue) {
                return 1;
            }
            return 0;
        }
    }
}

