/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.filters;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.abdera.i18n.text.io.CompressionUtil;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextWrapper;
import org.apache.abdera.writer.Writer;

public class CompressionFilter
implements Filter {
    public ResponseContext filter(RequestContext request, FilterChain chain) {
        String[] encodings;
        String encoding = request.getHeader("Accept-Encoding");
        for (String enc : encodings = encoding != null ? ProviderHelper.orderByQ(encoding) : new String[]{}) {
            try {
                CompressionUtil.CompressionCodec codec = CompressionUtil.CompressionCodec.valueOf((String)enc.toUpperCase());
                return new CompressingResponseContextWrapper(chain.next(request), codec);
            }
            catch (Exception e) {
            }
        }
        return chain.next(request);
    }

    public static class CompressingOutputStream
    extends FilterOutputStream {
        public CompressingOutputStream(CompressionUtil.CompressionCodec codec, OutputStream out) {
            super(CompressingOutputStream.initStream(codec, out));
        }

        public CompressingOutputStream(DeflaterOutputStream dout) {
            super(dout);
        }

        private static OutputStream initStream(CompressionUtil.CompressionCodec codec, OutputStream out) {
            try {
                return CompressionUtil.getEncodedOutputStream((OutputStream)out, (CompressionUtil.CompressionCodec)codec);
            }
            catch (Exception e) {
                return out;
            }
        }
    }

    public static class CompressingResponseContextWrapper
    extends ResponseContextWrapper {
        private final CompressionUtil.CompressionCodec codec;

        public CompressingResponseContextWrapper(ResponseContext response, CompressionUtil.CompressionCodec codec) {
            super(response);
            this.codec = codec;
        }

        private OutputStream wrap(OutputStream out) {
            return new CompressingOutputStream(this.codec, out);
        }

        public void writeTo(OutputStream out, Writer writer) throws IOException {
            out = this.wrap(out);
            super.writeTo(out, writer);
            out.flush();
        }

        public void writeTo(OutputStream out) throws IOException {
            out = this.wrap(out);
            super.writeTo(out);
            out.flush();
        }
    }
}

