/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.accumulo.core.cli.MapReduceClientOnRequiredTable;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraSortIngest
extends Configured
implements Tool {
    private static String NUMSPLITS = "terasort.overridesplits";
    private static String NUMROWS = "terasort.numrows";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new TeraSortIngest(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName("TeraSortCloud");
        job.setJarByClass(((Object)((Object)this)).getClass());
        Opts opts = new Opts();
        opts.parseArgs(TeraSortIngest.class.getName(), args, new Object[0]);
        job.setInputFormatClass(RangeInputFormat.class);
        job.setMapperClass(SortGenMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        opts.setAccumuloConfigs(job);
        BatchWriterConfig bwConfig = new BatchWriterConfig().setMaxMemory(10000000L);
        AccumuloOutputFormat.setBatchWriterOptions((Job)job, (BatchWriterConfig)bwConfig);
        Configuration conf = job.getConfiguration();
        conf.setLong(NUMROWS, opts.numRows);
        conf.setInt("cloudgen.minkeylength", opts.minKeyLength);
        conf.setInt("cloudgen.maxkeylength", opts.maxKeyLength);
        conf.setInt("cloudgen.minvaluelength", opts.minValueLength);
        conf.setInt("cloudgen.maxvaluelength", opts.maxValueLength);
        conf.set("cloudgen.tablename", opts.getTableName());
        if (args.length > 10) {
            conf.setInt(NUMSPLITS, opts.splits);
        }
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    static class Opts
    extends MapReduceClientOnRequiredTable {
        @Parameter(names={"--count"}, description="number of rows to ingest", required=true)
        long numRows;
        @Parameter(names={"-nk", "--minKeySize"}, description="miniumum key size", required=true)
        int minKeyLength;
        @Parameter(names={"-xk", "--maxKeySize"}, description="maximum key size", required=true)
        int maxKeyLength;
        @Parameter(names={"-nv", "--minValueSize"}, description="minimum key size", required=true)
        int minValueLength;
        @Parameter(names={"-xv", "--maxValueSize"}, description="maximum key size", required=true)
        int maxValueLength;
        @Parameter(names={"--splits"}, description="number of splits to create in the table")
        int splits = 0;

        Opts() {
        }
    }

    public static class SortGenMapper
    extends Mapper<LongWritable, NullWritable, Text, Mutation> {
        private Text table = null;
        private int minkeylength = 0;
        private int maxkeylength = 0;
        private int minvaluelength = 0;
        private int maxvaluelength = 0;
        private Text key = new Text();
        private Text value = new Text();
        private RandomGenerator rand;
        private byte[] keyBytes;
        private byte[] spaces = "          ".getBytes();
        private byte[][] filler = new byte[26][];
        private Random random;

        public SortGenMapper() {
            for (int i = 0; i < 26; ++i) {
                this.filler[i] = new byte[10];
                for (int j = 0; j < 10; ++j) {
                    this.filler[i][j] = (byte)(65 + i);
                }
            }
            this.random = new Random();
        }

        private void addKey() {
            int range = this.random.nextInt(this.maxkeylength - this.minkeylength + 1);
            int keylen = range + this.minkeylength;
            int keyceil = keylen + (4 - keylen % 4);
            this.keyBytes = new byte[keyceil];
            long temp = 0L;
            for (int i = 0; i < keyceil / 4; ++i) {
                temp = this.rand.next() / 52L;
                this.keyBytes[3 + 4 * i] = (byte)(32L + temp % 95L);
                this.keyBytes[2 + 4 * i] = (byte)(32L + (temp /= 95L) % 95L);
                this.keyBytes[1 + 4 * i] = (byte)(32L + (temp /= 95L) % 95L);
                this.keyBytes[4 * i] = (byte)(32L + (temp /= 95L) % 95L);
            }
            this.key.set(this.keyBytes, 0, keylen);
        }

        private Text getRowIdString(long rowId) {
            Text paddedRowIdString = new Text();
            byte[] rowid = Integer.toString((int)rowId).getBytes();
            int padSpace = 10 - rowid.length;
            if (padSpace > 0) {
                paddedRowIdString.append(this.spaces, 0, 10 - rowid.length);
            }
            paddedRowIdString.append(rowid, 0, Math.min(rowid.length, 10));
            return paddedRowIdString;
        }

        private void addFiller(long rowId) {
            int valuelen;
            int base = (int)(rowId * 8L % 26L);
            Random random = new Random(this.rand.seed);
            int range = random.nextInt(this.maxvaluelength - this.minvaluelength + 1);
            for (valuelen = range + this.minvaluelength; valuelen > 10; valuelen -= 10) {
                this.value.append(this.filler[(base + valuelen) % 26], 0, 10);
            }
            if (valuelen > 0) {
                this.value.append(this.filler[(base + valuelen) % 26], 0, valuelen);
            }
        }

        public void map(LongWritable row, NullWritable ignored, Mapper.Context context) throws IOException, InterruptedException {
            context.setStatus("Entering");
            long rowId = row.get();
            if (this.rand == null) {
                this.rand = new RandomGenerator(rowId * 3L);
            }
            this.addKey();
            this.value.clear();
            this.addFiller(rowId);
            Mutation m = new Mutation(this.key);
            m.put(new Text("c"), this.getRowIdString(rowId), new Value(this.value.toString().getBytes()));
            context.setStatus("About to add to accumulo");
            context.write((Object)this.table, (Object)m);
            context.setStatus("Added to accumulo " + this.key.toString());
        }

        public void setup(Mapper.Context job) {
            this.minkeylength = job.getConfiguration().getInt("cloudgen.minkeylength", 0);
            this.maxkeylength = job.getConfiguration().getInt("cloudgen.maxkeylength", 0);
            this.minvaluelength = job.getConfiguration().getInt("cloudgen.minvaluelength", 0);
            this.maxvaluelength = job.getConfiguration().getInt("cloudgen.maxvaluelength", 0);
            this.table = new Text(job.getConfiguration().get("cloudgen.tablename"));
        }
    }

    static class RandomGenerator {
        private long seed = 0L;
        private static final long mask32 = 0xFFFFFFFFL;
        private static final int seedSkip = 0x8000000;
        private static final long[] seeds = new long[]{0L, 0xF8000000L, 0xF0000000L, 0xE8000000L, 0xE0000000L, 0xD8000000L, 0xD0000000L, 0xC8000000L, 0xC0000000L, 0xB8000000L, 0xB0000000L, 0xA8000000L, 0xA0000000L, 0x98000000L, 0x90000000L, 0x88000000L, 0x80000000L, 0x78000000L, 0x70000000L, 0x68000000L, 0x60000000L, 0x58000000L, 0x50000000L, 0x48000000L, 0x40000000L, 0x38000000L, 0x30000000L, 0x28000000L, 0x20000000L, 0x18000000L, 0x10000000L, 0x8000000L};

        RandomGenerator(long initalIteration) {
            int baseIndex = (int)((initalIteration & 0xFFFFFFFFL) / 0x8000000L);
            this.seed = seeds[baseIndex];
            int i = 0;
            while ((long)i < initalIteration % 0x8000000L) {
                this.next();
                ++i;
            }
        }

        RandomGenerator() {
            this(0L);
        }

        long next() {
            this.seed = this.seed * 3141592621L + 663896637L & 0xFFFFFFFFL;
            return this.seed;
        }
    }

    static class RangeInputFormat
    extends InputFormat<LongWritable, NullWritable> {
        RangeInputFormat() {
        }

        public RecordReader<LongWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new RangeRecordReader((RangeInputSplit)split);
        }

        public List<InputSplit> getSplits(JobContext job) {
            long totalRows = job.getConfiguration().getLong(NUMROWS, 0L);
            int numSplits = job.getConfiguration().getInt(NUMSPLITS, 1);
            long rowsPerSplit = totalRows / (long)numSplits;
            System.out.println("Generating " + totalRows + " using " + numSplits + " maps with step of " + rowsPerSplit);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numSplits);
            long currentRow = 0L;
            for (int split = 0; split < numSplits - 1; ++split) {
                splits.add(new RangeInputSplit(currentRow, rowsPerSplit));
                currentRow += rowsPerSplit;
            }
            splits.add(new RangeInputSplit(currentRow, totalRows - currentRow));
            System.out.println("Done Generating.");
            return splits;
        }

        static class RangeRecordReader
        extends RecordReader<LongWritable, NullWritable> {
            long startRow;
            long finishedRows;
            long totalRows;

            public RangeRecordReader(RangeInputSplit split) {
                this.startRow = split.firstRow;
                this.finishedRows = 0L;
                this.totalRows = split.rowCount;
            }

            public void close() throws IOException {
            }

            public float getProgress() throws IOException {
                return (float)this.finishedRows / (float)this.totalRows;
            }

            public LongWritable getCurrentKey() throws IOException, InterruptedException {
                return new LongWritable(this.startRow + this.finishedRows);
            }

            public NullWritable getCurrentValue() throws IOException, InterruptedException {
                return NullWritable.get();
            }

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.finishedRows < this.totalRows) {
                    ++this.finishedRows;
                    return true;
                }
                return false;
            }
        }

        static class RangeInputSplit
        extends InputSplit
        implements Writable {
            long firstRow;
            long rowCount;

            public RangeInputSplit() {
            }

            public RangeInputSplit(long offset, long length) {
                this.firstRow = offset;
                this.rowCount = length;
            }

            public long getLength() throws IOException {
                return 0L;
            }

            public String[] getLocations() throws IOException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
                this.firstRow = WritableUtils.readVLong((DataInput)in);
                this.rowCount = WritableUtils.readVLong((DataInput)in);
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVLong((DataOutput)out, (long)this.firstRow);
                WritableUtils.writeVLong((DataOutput)out, (long)this.rowCount);
            }
        }
    }
}

