/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.examples.simple.filedata.ChunkInputStream;
import org.apache.accumulo.examples.simple.filedata.FileDataIngest;

public class FileDataQuery {
    private Connector conn = null;
    List<Map.Entry<Key, Value>> lastRefs;
    private ChunkInputStream cis;
    Scanner scanner;

    public FileDataQuery(String instanceName, String zooKeepers, String user, AuthenticationToken token, String tableName, Authorizations auths) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ZooKeeperInstance instance = new ZooKeeperInstance(ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers));
        this.conn = instance.getConnector(user, token);
        this.lastRefs = new ArrayList<Map.Entry<Key, Value>>();
        this.cis = new ChunkInputStream();
        this.scanner = this.conn.createScanner(tableName, auths);
    }

    public List<Map.Entry<Key, Value>> getLastRefs() {
        return this.lastRefs;
    }

    public ChunkInputStream getData(String hash) throws IOException {
        this.scanner.setRange(new Range((CharSequence)hash));
        this.scanner.setBatchSize(1);
        this.lastRefs.clear();
        PeekingIterator pi = new PeekingIterator(this.scanner.iterator());
        if (pi.hasNext()) {
            while (!((Key)((Map.Entry)pi.peek()).getKey()).getColumnFamily().equals((Object)FileDataIngest.CHUNK_CF)) {
                this.lastRefs.add((Map.Entry<Key, Value>)pi.peek());
                pi.next();
            }
        }
        this.cis.clear();
        this.cis.setSource((PeekingIterator<Map.Entry<Key, Value>>)pi);
        return this.cis;
    }

    public String getSomeData(String hash, int numBytes) throws IOException {
        byte[] buf;
        ChunkInputStream is = this.getData(hash);
        if (is.read(buf = new byte[numBytes]) >= 0) {
            return new String(buf);
        }
        return "";
    }
}

