/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.StackOverflowException;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;

public class ZooStore<T>
implements TStore<T> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private String path;
    private IZooReaderWriter zk;
    private String lastReserved = "";
    private Set<Long> reserved;
    private Map<Long, Long> defered;
    private SecureRandom idgenerator;
    private long statusChangeEvents = 0L;
    private int reservationsWaiting = 0;

    private byte[] serialize(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object deserialize(byte[] ser) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(ser);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getTXPath(long tid) {
        return String.format("%s/tx_%016x", this.path, tid);
    }

    private long parseTid(String txdir) {
        return Long.parseLong(txdir.split("_")[1], 16);
    }

    public ZooStore(String path, IZooReaderWriter zk) throws KeeperException, InterruptedException {
        this.path = path;
        this.zk = zk;
        this.reserved = new HashSet<Long>();
        this.defered = new HashMap<Long, Long>();
        this.idgenerator = new SecureRandom();
        zk.putPersistentData(path, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
    }

    /*
     * Loose catch block
     */
    @Override
    public long create() {
        while (true) {
            try {
                long tid = this.idgenerator.nextLong() & Long.MAX_VALUE;
                this.zk.putPersistentData(this.getTXPath(tid), ReadOnlyTStore.TStatus.NEW.name().getBytes(UTF8), ZooUtil.NodeExistsPolicy.FAIL);
                return tid;
            }
            catch (KeeperException.NodeExistsException nee) {
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long reserve() {
        try {
            while (true) {
                long events;
                ZooStore zooStore = this;
                synchronized (zooStore) {
                    events = this.statusChangeEvents;
                }
                ArrayList<String> txdirs = new ArrayList<String>(this.zk.getChildren(this.path));
                Collections.sort(txdirs);
                ZooStore zooStore2 = this;
                synchronized (zooStore2) {
                    if (txdirs.size() > 0 && ((String)txdirs.get(txdirs.size() - 1)).compareTo(this.lastReserved) <= 0) {
                        this.lastReserved = "";
                    }
                }
                for (String txdir : txdirs) {
                    long tid = this.parseTid(txdir);
                    ZooStore zooStore3 = this;
                    synchronized (zooStore3) {
                        if (txdir.compareTo(this.lastReserved) <= 0) {
                            continue;
                        }
                        if (this.defered.containsKey(tid)) {
                            if (this.defered.get(tid) < System.currentTimeMillis()) {
                                this.defered.remove(tid);
                            } else {
                                continue;
                            }
                        }
                        if (!this.reserved.contains(tid)) {
                            this.reserved.add(tid);
                            this.lastReserved = txdir;
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 9, 13, 14] lbl34 : MonitorExitStatement: MONITOREXIT : var8_7
                            try {
                                ReadOnlyTStore.TStatus status = ReadOnlyTStore.TStatus.valueOf(new String(this.zk.getData(this.path + "/" + txdir, null), UTF8));
                                if (status == ReadOnlyTStore.TStatus.IN_PROGRESS || status == ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS) {
                                    return tid;
                                }
                                this.unreserve(tid);
                            }
                            catch (KeeperException.NoNodeException nne) {
                                this.unreserve(tid);
                            }
                            catch (Exception e) {
                                this.unreserve(tid);
                                throw e;
                            }
                        }
                    }
                }
                zooStore2 = this;
                synchronized (zooStore2) {
                    if (events == this.statusChangeEvents) {
                        if (this.defered.size() > 0) {
                            Long minTime = Collections.min(this.defered.values());
                            long waitTime = minTime - System.currentTimeMillis();
                            if (waitTime > 0L) {
                                this.wait(Math.min(waitTime, 5000L));
                            }
                        } else {
                            this.wait(5000L);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reserve(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            ++this.reservationsWaiting;
            try {
                while (this.reserved.contains(tid)) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.reserved.add(tid);
            }
            finally {
                --this.reservationsWaiting;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserve(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.remove(tid)) {
                throw new IllegalStateException("Tried to unreserve id that was not reserved " + String.format("%016x", tid));
            }
            if (this.reservationsWaiting > 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unreserve(long tid, long deferTime) {
        if (deferTime < 0L) {
            throw new IllegalArgumentException("deferTime < 0 : " + deferTime);
        }
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.remove(tid)) {
                throw new IllegalStateException("Tried to unreserve id that was not reserved " + String.format("%016x", tid));
            }
            if (deferTime > 0L) {
                this.defered.put(tid, System.currentTimeMillis() + deferTime);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyReserved(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.contains(tid)) {
                throw new IllegalStateException("Tried to operate on unreserved transaction " + String.format("%016x", tid));
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Repo<T> top(long tid) {
        this.verifyReserved(tid);
        while (true) {
            try {
                String txpath = this.getTXPath(tid);
                String top = this.findTop(txpath);
                if (top == null) {
                    return null;
                }
                byte[] ser = this.zk.getData(txpath + "/" + top, null);
                return (Repo)this.deserialize(ser);
            }
            catch (KeeperException.NoNodeException ex) {
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String findTop(String txpath) throws KeeperException, InterruptedException {
        List<String> ops = this.zk.getChildren(txpath);
        ops = new ArrayList<String>(ops);
        String max = "";
        for (String child : ops) {
            if (!child.startsWith("repo_") || child.compareTo(max) <= 0) continue;
            max = child;
        }
        if (max.equals("")) {
            return null;
        }
        return max;
    }

    @Override
    public void push(long tid, Repo<T> repo) throws StackOverflowException {
        this.verifyReserved(tid);
        String txpath = this.getTXPath(tid);
        try {
            String top = this.findTop(txpath);
            if (top != null && Long.parseLong(top.split("_")[1]) > 100L) {
                throw new StackOverflowException("Repo stack size too large");
            }
            this.zk.putPersistentSequential(txpath + "/repo_", this.serialize(repo));
        }
        catch (StackOverflowException soe) {
            throw soe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pop(long tid) {
        this.verifyReserved(tid);
        try {
            String txpath = this.getTXPath(tid);
            String top = this.findTop(txpath);
            if (top == null) {
                throw new IllegalStateException("Tried to pop when empty " + tid);
            }
            this.zk.recursiveDelete(txpath + "/" + top, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ReadOnlyTStore.TStatus _getStatus(long tid) {
        try {
            return ReadOnlyTStore.TStatus.valueOf(new String(this.zk.getData(this.getTXPath(tid), null), UTF8));
        }
        catch (KeeperException.NoNodeException nne) {
            return ReadOnlyTStore.TStatus.UNKNOWN;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReadOnlyTStore.TStatus getStatus(long tid) {
        this.verifyReserved(tid);
        return this._getStatus(tid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadOnlyTStore.TStatus waitForStatusChange(long tid, EnumSet<ReadOnlyTStore.TStatus> expected) {
        while (true) {
            long events;
            ZooStore zooStore = this;
            synchronized (zooStore) {
                events = this.statusChangeEvents;
            }
            ReadOnlyTStore.TStatus status = this._getStatus(tid);
            if (expected.contains((Object)status)) {
                return status;
            }
            ZooStore zooStore2 = this;
            synchronized (zooStore2) {
                if (events == this.statusChangeEvents) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(long tid, ReadOnlyTStore.TStatus status) {
        this.verifyReserved(tid);
        try {
            this.zk.putPersistentData(this.getTXPath(tid), status.name().getBytes(UTF8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ZooStore zooStore = this;
        synchronized (zooStore) {
            ++this.statusChangeEvents;
        }
    }

    @Override
    public void delete(long tid) {
        this.verifyReserved(tid);
        try {
            this.zk.recursiveDelete(this.getTXPath(tid), ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setProperty(long tid, String prop, Serializable so) {
        this.verifyReserved(tid);
        try {
            if (so instanceof String) {
                this.zk.putPersistentData(this.getTXPath(tid) + "/prop_" + prop, ("S " + so).getBytes(UTF8), ZooUtil.NodeExistsPolicy.OVERWRITE);
            } else {
                byte[] sera = this.serialize(so);
                byte[] data = new byte[sera.length + 2];
                System.arraycopy(sera, 0, data, 2, sera.length);
                data[0] = 79;
                data[1] = 32;
                this.zk.putPersistentData(this.getTXPath(tid) + "/prop_" + prop, data, ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Serializable getProperty(long tid, String prop) {
        this.verifyReserved(tid);
        try {
            byte[] data = this.zk.getData(this.getTXPath(tid) + "/prop_" + prop, null);
            if (data[0] == 79) {
                byte[] sera = new byte[data.length - 2];
                System.arraycopy(data, 2, sera, 0, sera.length);
                return (Serializable)this.deserialize(sera);
            }
            if (data[0] == 83) {
                return new String(data, 2, data.length - 2, UTF8);
            }
            throw new IllegalStateException("Bad property data " + prop);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Long> list() {
        try {
            ArrayList<Long> l = new ArrayList<Long>();
            List<String> transactions = this.zk.getChildren(this.path);
            for (String txid : transactions) {
                l.add(this.parseTid(txid));
            }
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

