/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import org.apache.log4j.Logger;

public class Retry {
    private static final Logger log = Logger.getLogger(Retry.class);
    private long maxRetries;
    private long maxWait;
    private long waitIncrement;
    private long retriesDone;
    private long currentWait;

    public Retry(long maxRetries, long startWait, long waitIncrement, long maxWait) {
        this.maxRetries = maxRetries;
        this.maxWait = maxWait;
        this.waitIncrement = waitIncrement;
        this.retriesDone = 0L;
        this.currentWait = startWait;
    }

    long getMaxRetries() {
        return this.maxRetries;
    }

    long getCurrentWait() {
        return this.currentWait;
    }

    long getWaitIncrement() {
        return this.waitIncrement;
    }

    long getMaxWait() {
        return this.maxWait;
    }

    void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    void setStartWait(long startWait) {
        this.currentWait = startWait;
    }

    void setWaitIncrement(long waitIncrement) {
        this.waitIncrement = waitIncrement;
    }

    void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public boolean canRetry() {
        return this.retriesDone < this.maxRetries;
    }

    public void useRetry() {
        if (!this.canRetry()) {
            throw new IllegalStateException("No retries left");
        }
        ++this.retriesDone;
    }

    public boolean hasRetried() {
        return this.retriesDone > 0L;
    }

    public long retriesCompleted() {
        return this.retriesDone;
    }

    public void waitForNextAttempt() throws InterruptedException {
        log.debug((Object)("Sleeping for " + this.currentWait + "ms before retrying operation"));
        this.sleep(this.currentWait);
        this.currentWait = Math.min(this.maxWait, this.currentWait + this.waitIncrement);
    }

    protected void sleep(long wait) throws InterruptedException {
        Thread.sleep(wait);
    }
}

