/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooCache {
    private static final Logger log = Logger.getLogger(ZooCache.class);
    private final ZCacheWatcher watcher = new ZCacheWatcher();
    private final Watcher externalWatcher;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(false);
    private final Lock cacheWriteLock = this.cacheLock.writeLock();
    private final Lock cacheReadLock = this.cacheLock.readLock();
    private final HashMap<String, byte[]> cache;
    private final HashMap<String, Stat> statCache;
    private final HashMap<String, List<String>> childrenCache;
    private final ZooReader zReader;
    private static ZooCacheFactory zcf = new ZooCacheFactory();

    private ZooKeeper getZooKeeper() {
        return this.zReader.getZooKeeper();
    }

    public ZooCache(String zooKeepers, int sessionTimeout) {
        this(zooKeepers, sessionTimeout, null);
    }

    public ZooCache(String zooKeepers, int sessionTimeout, Watcher watcher) {
        this(new ZooReader(zooKeepers, sessionTimeout), watcher);
    }

    public ZooCache(ZooReader reader, Watcher watcher) {
        this.zReader = reader;
        this.cache = new HashMap();
        this.statCache = new HashMap();
        this.childrenCache = new HashMap();
        this.externalWatcher = watcher;
    }

    public synchronized List<String> getChildren(final String zPath) {
        ZooRunnable<List<String>> zr = new ZooRunnable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> run(ZooKeeper zooKeeper) throws KeeperException, InterruptedException {
                try {
                    ZooCache.this.cacheReadLock.lock();
                    if (ZooCache.this.childrenCache.containsKey(zPath)) {
                        List list = (List)ZooCache.this.childrenCache.get(zPath);
                        return list;
                    }
                }
                finally {
                    ZooCache.this.cacheReadLock.unlock();
                }
                ZooCache.this.cacheWriteLock.lock();
                try {
                    if (ZooCache.this.childrenCache.containsKey(zPath)) {
                        List list = (List)ZooCache.this.childrenCache.get(zPath);
                        return list;
                    }
                    List children = zooKeeper.getChildren(zPath, (Watcher)ZooCache.this.watcher);
                    ZooCache.this.childrenCache.put(zPath, children);
                    List list = children;
                    return list;
                }
                catch (KeeperException ke) {
                    if (ke.code() != KeeperException.Code.NONODE) {
                        throw ke;
                    }
                }
                finally {
                    ZooCache.this.cacheWriteLock.unlock();
                }
                return null;
            }
        };
        List children = (List)zr.retry();
        if (children == null) {
            return null;
        }
        return Collections.unmodifiableList(children);
    }

    public byte[] get(String zPath) {
        return this.get(zPath, null);
    }

    public byte[] get(final String zPath, final Stat status) {
        ZooRunnable<byte[]> zr = new ZooRunnable<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] run(ZooKeeper zooKeeper) throws KeeperException, InterruptedException {
                Stat stat = null;
                ZooCache.this.cacheReadLock.lock();
                try {
                    if (ZooCache.this.cache.containsKey(zPath)) {
                        stat = (Stat)ZooCache.this.statCache.get(zPath);
                        ZooCache.this.copyStats(status, stat);
                        byte[] byArray = (byte[])ZooCache.this.cache.get(zPath);
                        return byArray;
                    }
                }
                finally {
                    ZooCache.this.cacheReadLock.unlock();
                }
                ZooCache.this.cacheWriteLock.lock();
                try {
                    stat = zooKeeper.exists(zPath, (Watcher)ZooCache.this.watcher);
                    byte[] data = null;
                    if (stat == null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("zookeeper did not contain " + zPath));
                        }
                    } else {
                        try {
                            data = zooKeeper.getData(zPath, (Watcher)ZooCache.this.watcher, stat);
                        }
                        catch (KeeperException.BadVersionException e1) {
                            throw new ConcurrentModificationException();
                        }
                        catch (KeeperException.NoNodeException e2) {
                            throw new ConcurrentModificationException();
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("zookeeper contained " + zPath + " " + (data == null ? null : new String(data, Charsets.UTF_8))));
                        }
                    }
                    ZooCache.this.put(zPath, data, stat);
                    ZooCache.this.copyStats(status, stat);
                    ZooCache.this.statCache.put(zPath, stat);
                    byte[] byArray = data;
                    return byArray;
                }
                finally {
                    ZooCache.this.cacheWriteLock.unlock();
                }
            }
        };
        return (byte[])zr.retry();
    }

    protected void copyStats(Stat userStat, Stat cachedStat) {
        if (userStat != null && cachedStat != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                cachedStat.write((DataOutput)dos);
                dos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                DataInputStream dis = new DataInputStream(bais);
                userStat.readFields((DataInput)dis);
                dis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String zPath, byte[] data, Stat stat) {
        this.cacheWriteLock.lock();
        try {
            this.cache.put(zPath, data);
            this.statCache.put(zPath, stat);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String zPath) {
        this.cacheWriteLock.lock();
        try {
            this.cache.remove(zPath);
            this.childrenCache.remove(zPath);
            this.statCache.remove(zPath);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        this.cacheWriteLock.lock();
        try {
            this.cache.clear();
            this.childrenCache.clear();
            this.statCache.clear();
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    @VisibleForTesting
    synchronized boolean dataCached(String zPath) {
        return this.cache.containsKey(zPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean childrenCached(String zPath) {
        this.cacheReadLock.lock();
        try {
            boolean bl = this.childrenCache.containsKey(zPath);
            return bl;
        }
        finally {
            this.cacheReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String zPath) {
        this.cacheWriteLock.lock();
        try {
            String path;
            Iterator<String> i = this.cache.keySet().iterator();
            while (i.hasNext()) {
                path = i.next();
                if (!path.startsWith(zPath)) continue;
                i.remove();
            }
            i = this.childrenCache.keySet().iterator();
            while (i.hasNext()) {
                path = i.next();
                if (!path.startsWith(zPath)) continue;
                i.remove();
            }
            i = this.statCache.keySet().iterator();
            while (i.hasNext()) {
                path = i.next();
                if (!path.startsWith(zPath)) continue;
                i.remove();
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    @Deprecated
    public static synchronized ZooCache getInstance(String zooKeepers, int sessionTimeout) {
        return zcf.getZooCache(zooKeepers, sessionTimeout);
    }

    private abstract class ZooRunnable<T> {
        private ZooRunnable() {
        }

        abstract T run(ZooKeeper var1) throws KeeperException, InterruptedException;

        public T retry() {
            int sleepTime = 100;
            while (true) {
                ZooKeeper zooKeeper = ZooCache.this.getZooKeeper();
                try {
                    return this.run(zooKeeper);
                }
                catch (KeeperException e) {
                    KeeperException.Code code = e.code();
                    if (code == KeeperException.Code.NONODE) {
                        log.error((Object)("Looked up non-existent node in cache " + e.getPath()), (Throwable)e);
                    } else if (code == KeeperException.Code.CONNECTIONLOSS || code == KeeperException.Code.OPERATIONTIMEOUT || code == KeeperException.Code.SESSIONEXPIRED) {
                        log.warn((Object)"Saw (possibly) transient exception communicating with ZooKeeper, will retry", (Throwable)e);
                    } else {
                        log.warn((Object)"Zookeeper error, will retry", (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    log.info((Object)"Zookeeper error, will retry", (Throwable)e);
                }
                catch (ConcurrentModificationException e) {
                    log.debug((Object)"Zookeeper was modified, will retry");
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Wait in retry() was interrupted.", (Throwable)e);
                }
                LockSupport.parkNanos(sleepTime);
                if (sleepTime >= 10000) continue;
                sleepTime = (int)((double)sleepTime + (double)sleepTime * Math.random());
            }
        }
    }

    private class ZCacheWatcher
    implements Watcher {
        private ZCacheWatcher() {
        }

        public void process(WatchedEvent event) {
            if (log.isTraceEnabled()) {
                log.trace((Object)event);
            }
            block0 : switch (event.getType()) {
                case NodeDataChanged: 
                case NodeChildrenChanged: 
                case NodeCreated: 
                case NodeDeleted: {
                    ZooCache.this.remove(event.getPath());
                    break;
                }
                case None: {
                    switch (event.getState()) {
                        case Disconnected: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Zoo keeper connection disconnected, clearing cache");
                            }
                            ZooCache.this.clear();
                            break block0;
                        }
                        case SyncConnected: {
                            break block0;
                        }
                        case Expired: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Zoo keeper connection expired, clearing cache");
                            }
                            ZooCache.this.clear();
                            break block0;
                        }
                    }
                    log.warn((Object)("Unhandled: " + event));
                    break;
                }
                default: {
                    log.warn((Object)("Unhandled: " + event));
                }
            }
            if (ZooCache.this.externalWatcher != null) {
                ZooCache.this.externalWatcher.process(event);
            }
        }
    }
}

