/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.fate.AcceptableException;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.StackOverflowException;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fate<T> {
    private static final String DEBUG_PROP = "debug";
    private static final String AUTO_CLEAN_PROP = "autoClean";
    private static final String EXCEPTION_PROP = "exception";
    private static final String RETURN_PROP = "return";
    private static final Logger log = LoggerFactory.getLogger(Fate.class);
    private final Logger runnerLog = LoggerFactory.getLogger(TransactionRunner.class);
    private TStore<T> store;
    private T environment;
    private ExecutorService executor;
    private static final EnumSet<ReadOnlyTStore.TStatus> FINISHED_STATES = EnumSet.of(ReadOnlyTStore.TStatus.FAILED, ReadOnlyTStore.TStatus.SUCCESSFUL, ReadOnlyTStore.TStatus.UNKNOWN);
    private AtomicBoolean keepRunning = new AtomicBoolean(true);

    public Fate(T environment, TStore<T> store) {
        this.store = store;
        this.environment = environment;
    }

    public void startTransactionRunners(int numThreads) {
        final AtomicInteger runnerCount = new AtomicInteger(0);
        this.executor = Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread((Runnable)new LoggingRunnable(log, r), "Repo runner " + runnerCount.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
        for (int i = 0; i < numThreads; ++i) {
            this.executor.execute(new TransactionRunner());
        }
    }

    public long startTransaction() {
        long dir = this.store.create();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedTransaction(long tid, Repo<T> repo, boolean autoCleanUp) {
        block7: {
            this.store.reserve(tid);
            try {
                if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.NEW) break block7;
                if (this.store.top(tid) == null) {
                    try {
                        this.store.push(tid, repo);
                    }
                    catch (StackOverflowException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (autoCleanUp) {
                    this.store.setProperty(tid, AUTO_CLEAN_PROP, Boolean.valueOf(autoCleanUp));
                }
                this.store.setProperty(tid, DEBUG_PROP, (Serializable)((Object)repo.getDescription()));
                this.store.setStatus(tid, ReadOnlyTStore.TStatus.IN_PROGRESS);
            }
            finally {
                this.store.unreserve(tid, 0L);
            }
        }
    }

    public ReadOnlyTStore.TStatus waitForCompletion(long tid) {
        return this.store.waitForStatusChange(tid, FINISHED_STATES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(long tid) {
        this.store.reserve(tid);
        try {
            switch (this.store.getStatus(tid)) {
                case NEW: 
                case FAILED: 
                case SUCCESSFUL: {
                    this.store.delete(tid);
                    return;
                }
                case FAILED_IN_PROGRESS: 
                case IN_PROGRESS: {
                    throw new IllegalStateException("Can not delete in progress transaction " + String.format("%016x", tid));
                }
            }
            return;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReturn(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.SUCCESSFUL) {
                throw new IllegalStateException("Tried to get exception when transaction " + String.format("%016x", tid) + " not in successful state");
            }
            String string = (String)((Object)this.store.getProperty(tid, RETURN_PROP));
            return string;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getException(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.FAILED) {
                throw new IllegalStateException("Tried to get exception when transaction " + String.format("%016x", tid) + " not in failed state");
            }
            Exception exception = (Exception)this.store.getProperty(tid, EXCEPTION_PROP);
            return exception;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    public void shutdown() {
        this.keepRunning.set(false);
        this.executor.shutdown();
    }

    private class TransactionRunner
    implements Runnable {
        private TransactionRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (Fate.this.keepRunning.get()) {
                long deferTime = 0L;
                Long tid = null;
                try {
                    tid = Fate.this.store.reserve();
                    ReadOnlyTStore.TStatus status = Fate.this.store.getStatus(tid);
                    Repo<Object> op = Fate.this.store.top(tid);
                    if (status == ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS) {
                        this.processFailed(tid, op);
                        continue;
                    }
                    Repo<Object> prevOp = null;
                    try {
                        deferTime = op.isReady(tid, Fate.this.environment);
                        if (deferTime != 0L) continue;
                        prevOp = op;
                        op = op.call(tid, Fate.this.environment);
                    }
                    catch (Exception e) {
                        this.transitionToFailed(tid, op, e);
                        continue;
                    }
                    if (op == null) {
                        String ret = prevOp.getReturn();
                        if (ret != null) {
                            Fate.this.store.setProperty(tid, Fate.RETURN_PROP, (Serializable)((Object)ret));
                        }
                        Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.SUCCESSFUL);
                        this.doCleanUp(tid);
                        continue;
                    }
                    try {
                        Fate.this.store.push(tid, op);
                    }
                    catch (StackOverflowException e) {
                        this.transitionToFailed(tid, op, e);
                        if (null == tid) continue;
                        Fate.this.store.unreserve(tid, deferTime);
                    }
                }
                catch (Exception e) {
                    Fate.this.runnerLog.error("Uncaught exception in FATE runner thread.", (Throwable)e);
                }
                finally {
                    if (null == tid) continue;
                    Fate.this.store.unreserve(tid, deferTime);
                }
            }
        }

        private void transitionToFailed(long tid, Repo<T> op, Exception e) {
            String tidStr = String.format("%016x", tid);
            String msg = "Failed to execute Repo, tid=" + tidStr;
            if (e instanceof AcceptableException) {
                log.debug(msg, e.getCause());
            } else {
                log.warn(msg, (Throwable)e);
            }
            Fate.this.store.setProperty(tid, Fate.EXCEPTION_PROP, e);
            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS);
            log.info("Updated status for Repo with tid=" + tidStr + " to FAILED_IN_PROGRESS");
        }

        private void processFailed(long tid, Repo<T> op) {
            while (op != null) {
                this.undo(tid, op);
                Fate.this.store.pop(tid);
                op = Fate.this.store.top(tid);
            }
            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED);
            this.doCleanUp(tid);
        }

        private void doCleanUp(long tid) {
            Boolean autoClean = (Boolean)Fate.this.store.getProperty(tid, Fate.AUTO_CLEAN_PROP);
            if (autoClean != null && autoClean.booleanValue()) {
                Fate.this.store.delete(tid);
            } else {
                while (Fate.this.store.top(tid) != null) {
                    Fate.this.store.pop(tid);
                }
            }
        }

        private void undo(long tid, Repo<T> op) {
            try {
                op.undo(tid, Fate.this.environment);
            }
            catch (Exception e) {
                log.warn("Failed to undo Repo, tid=" + String.format("%016x", tid), (Throwable)e);
            }
        }
    }
}

