/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.beust.jcommander.Parameter;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.net.HostAndPort;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.SslConnectionParams;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.gc.GarbageCollectWriteAheadLogs;
import org.apache.accumulo.gc.GarbageCollectionAlgorithm;
import org.apache.accumulo.gc.GarbageCollectionEnvironment;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.TServerUtils;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.trace.instrument.CountSampler;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.thrift.TraceWrap;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TProcessor;
import org.apache.zookeeper.KeeperException;

public class SimpleGarbageCollector
implements GCMonitorService.Iface {
    private static final Text EMPTY_TEXT = new Text();
    static final float CANDIDATE_MEMORY_PERCENTAGE = 0.75f;
    private static final Logger log = Logger.getLogger(SimpleGarbageCollector.class);
    private Credentials credentials;
    private long gcStartDelay;
    private VolumeManager fs;
    private boolean useTrash = true;
    private Opts opts = new Opts();
    private ZooLock lock;
    private GCStatus status = new GCStatus(new GcCycleStats(), new GcCycleStats(), new GcCycleStats(), new GcCycleStats());
    private int numDeleteThreads;
    private Instance instance;
    static final String METADATA_TABLE_DIR = "/!0";

    public static void main(String[] args) throws UnknownHostException, IOException {
        SecurityUtil.serverLogin((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
        Instance instance = HdfsZooInstance.getInstance();
        ServerConfiguration serverConf = new ServerConfiguration(instance);
        VolumeManager fs = VolumeManagerImpl.get();
        Accumulo.init((VolumeManager)fs, (ServerConfiguration)serverConf, (String)"gc");
        Opts opts = new Opts();
        opts.parseArgs("gc", args, new Object[0]);
        SimpleGarbageCollector gc = new SimpleGarbageCollector(opts);
        gc.init(fs, instance, (Credentials)SystemCredentials.get(), serverConf.getConfiguration().getBoolean(Property.GC_TRASH_IGNORE));
        Accumulo.enableTracing((String)opts.getAddress(), (String)"gc");
        gc.run();
    }

    public SimpleGarbageCollector(Opts opts) {
        this.opts = opts;
    }

    Credentials getCredentials() {
        return this.credentials;
    }

    long getStartDelay() {
        return this.gcStartDelay;
    }

    VolumeManager getVolumeManager() {
        return this.fs;
    }

    boolean isUsingTrash() {
        return this.useTrash;
    }

    Opts getOpts() {
        return this.opts;
    }

    int getNumDeleteThreads() {
        return this.numDeleteThreads;
    }

    Instance getInstance() {
        return this.instance;
    }

    public void init(VolumeManager fs, Instance instance, Credentials credentials, boolean noTrash) {
        this.init(fs, instance, credentials, noTrash, ServerConfiguration.getSystemConfiguration((Instance)instance));
    }

    public void init(VolumeManager fs, Instance instance, Credentials credentials, boolean noTrash, AccumuloConfiguration systemConfig) {
        this.fs = fs;
        this.credentials = credentials;
        this.instance = instance;
        this.gcStartDelay = systemConfig.getTimeInMillis(Property.GC_CYCLE_START);
        long gcDelay = systemConfig.getTimeInMillis(Property.GC_CYCLE_DELAY);
        this.numDeleteThreads = systemConfig.getCount(Property.GC_DELETE_THREADS);
        log.info((Object)("start delay: " + this.gcStartDelay + " milliseconds"));
        log.info((Object)("time delay: " + gcDelay + " milliseconds"));
        log.info((Object)("safemode: " + this.opts.safeMode));
        log.info((Object)("verbose: " + this.opts.verbose));
        log.info((Object)("memory threshold: 0.75 of " + Runtime.getRuntime().maxMemory() + " bytes"));
        log.info((Object)("delete threads: " + this.numDeleteThreads));
        this.useTrash = !noTrash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            this.getZooLock(this.startStatsService());
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            System.exit(1);
        }
        try {
            log.debug((Object)("Sleeping for " + this.gcStartDelay + " milliseconds before beginning garbage collection cycles"));
            Thread.sleep(this.gcStartDelay);
        }
        catch (InterruptedException e) {
            log.warn((Object)e, (Throwable)e);
            return;
        }
        CountSampler sampler = new CountSampler(100L);
        while (true) {
            if (sampler.next()) {
                Trace.on((String)"gc");
            }
            Span gcSpan = Trace.start((String)"loop");
            long tStart = System.currentTimeMillis();
            try {
                System.gc();
                this.status.current.started = System.currentTimeMillis();
                new GarbageCollectionAlgorithm().collect(new GCEnv("accumulo.root"));
                new GarbageCollectionAlgorithm().collect(new GCEnv("accumulo.metadata"));
                log.info((Object)("Number of data file candidates for deletion: " + this.status.current.candidates));
                log.info((Object)("Number of data file candidates still in use: " + this.status.current.inUse));
                log.info((Object)("Number of successfully deleted data files: " + this.status.current.deleted));
                log.info((Object)("Number of data files delete failures: " + this.status.current.errors));
                this.status.current.finished = System.currentTimeMillis();
                this.status.last = this.status.current;
                this.status.current = new GcCycleStats();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            long tStop = System.currentTimeMillis();
            log.info((Object)String.format("Collect cycle took %.2f seconds", (double)(tStop - tStart) / 1000.0));
            Span waLogs = Trace.start((String)"walogs");
            try {
                GarbageCollectWriteAheadLogs walogCollector = new GarbageCollectWriteAheadLogs(this.instance, this.fs, this.useTrash);
                log.info((Object)"Beginning garbage collection of write-ahead logs");
                walogCollector.collect(this.status);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            finally {
                waLogs.stop();
            }
            gcSpan.stop();
            try {
                Connector connector = this.instance.getConnector(this.credentials.getPrincipal(), this.credentials.getToken());
                connector.tableOperations().compact("accumulo.metadata", null, null, true, true);
                connector.tableOperations().compact("accumulo.root", null, null, true, true);
            }
            catch (Exception e) {
                log.warn((Object)e, (Throwable)e);
            }
            Trace.offNoFlush();
            try {
                long gcDelay = ServerConfiguration.getSystemConfiguration((Instance)this.instance).getTimeInMillis(Property.GC_CYCLE_DELAY);
                log.debug((Object)("Sleeping for " + gcDelay + " milliseconds"));
                Thread.sleep(gcDelay);
            }
            catch (InterruptedException e) {
                log.warn((Object)e, (Throwable)e);
                return;
            }
        }
    }

    boolean moveToTrash(Path path) throws IOException {
        if (!this.useTrash) {
            return false;
        }
        try {
            return this.fs.moveToTrash(path);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    private void getZooLock(HostAndPort addr) throws KeeperException, InterruptedException {
        String path = ZooUtil.getRoot((Instance)this.instance) + "/gc/lock";
        ZooLock.LockWatcher lockWatcher = new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                Halt.halt((String)("GC lock in zookeeper lost (reason = " + reason + "), exiting!"));
            }

            public void unableToMonitorLockNode(final Throwable e) {
                Halt.halt((int)-1, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        log.fatal((Object)"No longer able to monitor lock node ", e);
                    }
                });
            }
        };
        while (true) {
            this.lock = new ZooLock(path);
            if (this.lock.tryLock(lockWatcher, new ServerServices(addr.toString(), ServerServices.Service.GC_CLIENT).toString().getBytes())) break;
            UtilWaitThread.sleep((long)1000L);
        }
    }

    private HostAndPort startStatsService() throws UnknownHostException {
        GCMonitorService.Processor processor = new GCMonitorService.Processor((GCMonitorService.Iface)TraceWrap.service((Object)this));
        AccumuloConfiguration conf = ServerConfiguration.getSystemConfiguration((Instance)this.instance);
        int port = conf.getPort(Property.GC_PORT);
        long maxMessageSize = conf.getMemoryInBytes(Property.GENERAL_MAX_MESSAGE_SIZE);
        HostAndPort result = HostAndPort.fromParts((String)this.opts.getAddress(), (int)port);
        log.debug((Object)("Starting garbage collector listening on " + result));
        try {
            return TServerUtils.startTServer((HostAndPort)result, (TProcessor)processor, (String)this.getClass().getSimpleName(), (String)"GC Monitor Service", (int)2, (long)1000L, (long)maxMessageSize, (SslConnectionParams)SslConnectionParams.forServer((AccumuloConfiguration)conf), (long)0L).address;
        }
        catch (Exception ex) {
            log.fatal((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    static boolean almostOutOfMemory(Runtime runtime) {
        return (float)(runtime.totalMemory() - runtime.freeMemory()) > 0.75f * (float)runtime.maxMemory();
    }

    private static void putMarkerDeleteMutation(String delete, BatchWriter writer) throws MutationsRejectedException {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.DeletesSection.getRowPrefix() + delete));
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        writer.addMutation(m);
    }

    static boolean isDir(String delete) {
        if (delete == null) {
            return false;
        }
        int slashCount = 0;
        for (int i = 0; i < delete.length(); ++i) {
            if (delete.charAt(i) != '/') continue;
            ++slashCount;
        }
        return slashCount == 1;
    }

    public GCStatus getStatus(TInfo info, TCredentials credentials) {
        return this.status;
    }

    private class GCEnv
    implements GarbageCollectionEnvironment {
        private String tableName;

        GCEnv(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public List<String> getCandidates(String continuePoint) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
            Range range = MetadataSchema.DeletesSection.getRange();
            if (continuePoint != null && !continuePoint.isEmpty()) {
                String continueRow = MetadataSchema.DeletesSection.getRowPrefix() + continuePoint;
                range = new Range(new Key((CharSequence)continueRow).followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
            }
            Scanner scanner = SimpleGarbageCollector.this.instance.getConnector(SimpleGarbageCollector.this.credentials.getPrincipal(), SimpleGarbageCollector.this.credentials.getToken()).createScanner(this.tableName, Authorizations.EMPTY);
            scanner.setRange(range);
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry entry : scanner) {
                String cand = ((Key)entry.getKey()).getRow().toString().substring(MetadataSchema.DeletesSection.getRowPrefix().length());
                result.add(cand);
                if (!SimpleGarbageCollector.almostOutOfMemory(Runtime.getRuntime())) continue;
                log.info((Object)"List of delete candidates has exceeded the memory threshold. Attempting to delete what has been gathered so far.");
                break;
            }
            return result;
        }

        @Override
        public Iterator<String> getBlipIterator() throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
            IsolatedScanner scanner = new IsolatedScanner(SimpleGarbageCollector.this.instance.getConnector(SimpleGarbageCollector.this.credentials.getPrincipal(), SimpleGarbageCollector.this.credentials.getToken()).createScanner(this.tableName, Authorizations.EMPTY));
            scanner.setRange(MetadataSchema.BlipSection.getRange());
            return Iterators.transform((Iterator)scanner.iterator(), (Function)new Function<Map.Entry<Key, Value>, String>(){

                public String apply(Map.Entry<Key, Value> entry) {
                    return entry.getKey().getRow().toString().substring(MetadataSchema.BlipSection.getRowPrefix().length());
                }
            });
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> getReferenceIterator() throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
            IsolatedScanner scanner = new IsolatedScanner(SimpleGarbageCollector.this.instance.getConnector(SimpleGarbageCollector.this.credentials.getPrincipal(), SimpleGarbageCollector.this.credentials.getToken()).createScanner(this.tableName, Authorizations.EMPTY));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME);
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
            TabletIterator tabletIterator = new TabletIterator((Scanner)scanner, MetadataSchema.TabletsSection.getRange(), false, true);
            return Iterators.concat((Iterator)Iterators.transform((Iterator)tabletIterator, (Function)new Function<Map<Key, Value>, Iterator<Map.Entry<Key, Value>>>(){

                public Iterator<Map.Entry<Key, Value>> apply(Map<Key, Value> input) {
                    return input.entrySet().iterator();
                }
            }));
        }

        @Override
        public Set<String> getTableIDs() {
            return Tables.getIdToNameMap((Instance)SimpleGarbageCollector.this.instance).keySet();
        }

        @Override
        public void delete(SortedMap<String, String> confirmedDeletes) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
            if (((SimpleGarbageCollector)SimpleGarbageCollector.this).opts.safeMode) {
                if (((SimpleGarbageCollector)SimpleGarbageCollector.this).opts.verbose) {
                    System.out.println("SAFEMODE: There are " + confirmedDeletes.size() + " data file candidates marked for deletion.%n" + "          Examine the log files to identify them.%n");
                }
                log.info((Object)"SAFEMODE: Listing all data file candidates for deletion");
                for (String s : confirmedDeletes.values()) {
                    log.info((Object)("SAFEMODE: " + s));
                }
                log.info((Object)"SAFEMODE: End candidates for deletion");
                return;
            }
            Connector c = SimpleGarbageCollector.this.instance.getConnector(SystemCredentials.get().getPrincipal(), SystemCredentials.get().getToken());
            BatchWriter writer = c.createBatchWriter(this.tableName, new BatchWriterConfig());
            Iterator<Map.Entry<String, String>> cdIter = confirmedDeletes.entrySet().iterator();
            String lastDir = null;
            while (cdIter.hasNext()) {
                Map.Entry<String, String> entry = cdIter.next();
                String relPath = entry.getKey();
                String absPath = SimpleGarbageCollector.this.fs.getFullPath(VolumeManager.FileType.TABLE, entry.getValue()).toString();
                if (SimpleGarbageCollector.isDir(relPath)) {
                    lastDir = absPath;
                    continue;
                }
                if (lastDir == null) continue;
                if (absPath.startsWith(lastDir)) {
                    log.debug((Object)("Ignoring " + entry.getValue() + " because " + lastDir + " exist"));
                    try {
                        SimpleGarbageCollector.putMarkerDeleteMutation(entry.getValue(), writer);
                    }
                    catch (MutationsRejectedException e) {
                        throw new RuntimeException(e);
                    }
                    cdIter.remove();
                    continue;
                }
                lastDir = null;
            }
            final BatchWriter finalWriter = writer;
            ExecutorService deleteThreadPool = Executors.newFixedThreadPool(SimpleGarbageCollector.this.numDeleteThreads, (ThreadFactory)new NamingThreadFactory("deleting"));
            final List replacements = ServerConstants.getVolumeReplacements();
            for (final String delete : confirmedDeletes.values()) {
                Runnable deleteTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            boolean removeFlag;
                            Path fullPath;
                            String switchedDelete = VolumeUtil.switchVolume((String)delete, (VolumeManager.FileType)VolumeManager.FileType.TABLE, (List)replacements);
                            if (switchedDelete != null) {
                                log.debug((Object)("Volume replaced " + delete + " -> " + switchedDelete));
                                fullPath = SimpleGarbageCollector.this.fs.getFullPath(VolumeManager.FileType.TABLE, switchedDelete);
                            } else {
                                fullPath = SimpleGarbageCollector.this.fs.getFullPath(VolumeManager.FileType.TABLE, delete);
                            }
                            log.debug((Object)("Deleting " + fullPath));
                            if (SimpleGarbageCollector.this.moveToTrash(fullPath) || SimpleGarbageCollector.this.fs.deleteRecursively(fullPath)) {
                                removeFlag = true;
                                SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                                synchronized (simpleGarbageCollector) {
                                    ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.deleted;
                                }
                            }
                            if (SimpleGarbageCollector.this.fs.exists(fullPath)) {
                                removeFlag = false;
                                SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                                synchronized (simpleGarbageCollector) {
                                    ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                                }
                                log.warn((Object)("File exists, but was not deleted for an unknown reason: " + fullPath));
                            } else {
                                removeFlag = true;
                                SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                                synchronized (simpleGarbageCollector) {
                                    ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                                }
                                String[] parts = delete.split("/");
                                if (parts.length > 2) {
                                    String tableId = parts[parts.length - 3];
                                    String tabletDir = parts[parts.length - 2];
                                    TableManager.getInstance().updateTableStateCache(tableId);
                                    TableState tableState = TableManager.getInstance().getTableState(tableId);
                                    if (tableState != null && tableState != TableState.DELETING && !tabletDir.startsWith("c-")) {
                                        log.warn((Object)("File doesn't exist: " + fullPath));
                                    }
                                } else {
                                    log.warn((Object)("Very strange path name: " + delete));
                                }
                            }
                            if (removeFlag && finalWriter != null) {
                                SimpleGarbageCollector.putMarkerDeleteMutation(delete, finalWriter);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                    }
                };
                deleteThreadPool.execute(deleteTask);
            }
            deleteThreadPool.shutdown();
            try {
                while (!deleteThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e1) {
                log.error((Object)e1, (Throwable)e1);
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (MutationsRejectedException e) {
                    log.error((Object)"Problem removing entries from the metadata table: ", (Throwable)e);
                }
            }
        }

        @Override
        public void deleteTableDirIfEmpty(String tableID) throws IOException {
            for (String dir : ServerConstants.getTablesDirs()) {
                FileStatus[] tabletDirs = null;
                try {
                    tabletDirs = SimpleGarbageCollector.this.fs.listStatus(new Path(dir + "/" + tableID));
                }
                catch (FileNotFoundException ex) {
                    // empty catch block
                }
                if (tabletDirs == null || tabletDirs.length != 0) continue;
                Path p = new Path(dir + "/" + tableID);
                log.debug((Object)("Removing table dir " + p));
                if (SimpleGarbageCollector.this.moveToTrash(p)) continue;
                SimpleGarbageCollector.this.fs.delete(p);
            }
        }

        @Override
        public void incrementCandidatesStat(long i) {
            ((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.candidates += i;
        }

        @Override
        public void incrementInUseStat(long i) {
            ((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.inUse += i;
        }
    }

    static class Opts
    extends ServerOpts {
        @Parameter(names={"-v", "--verbose"}, description="extra information will get printed to stdout also")
        boolean verbose = false;
        @Parameter(names={"-s", "--safemode"}, description="safe mode will not delete files")
        boolean safeMode = false;

        Opts() {
        }
    }
}

