/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.gc.GarbageCollectWriteAheadLogs;
import org.apache.accumulo.gc.GarbageCollectionAlgorithm;
import org.apache.accumulo.gc.GarbageCollectionEnvironment;
import org.apache.accumulo.gc.replication.CloseWriteAheadLogReferences;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TCredentialsUpdatingWrapper;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.util.Halt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.ProbabilitySampler;
import org.apache.thrift.TProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGarbageCollector
extends AbstractServer
implements GCMonitorService.Iface {
    private static final Text EMPTY_TEXT = new Text();
    static final float CANDIDATE_MEMORY_PERCENTAGE = 0.5f;
    private static final Logger log = LoggerFactory.getLogger(SimpleGarbageCollector.class);
    private GCOpts opts;
    private ZooLock lock;
    private GCStatus status = new GCStatus(new GcCycleStats(), new GcCycleStats(), new GcCycleStats(), new GcCycleStats());

    public static void main(String[] args) throws Exception {
        try (SimpleGarbageCollector gc = new SimpleGarbageCollector(new GCOpts(), args);){
            gc.runServer();
        }
    }

    SimpleGarbageCollector(GCOpts opts, String[] args) {
        super("gc", (ServerOpts)opts, args);
        this.opts = opts;
        long gcDelay = this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_DELAY);
        log.info("start delay: {} milliseconds", (Object)this.getStartDelay());
        log.info("time delay: {} milliseconds", (Object)gcDelay);
        log.info("safemode: {}", (Object)opts.safeMode);
        log.info("verbose: {}", (Object)opts.verbose);
        log.info("memory threshold: {} of {} bytes", (Object)Float.valueOf(0.5f), (Object)Runtime.getRuntime().maxMemory());
        log.info("delete threads: {}", (Object)this.getNumDeleteThreads());
    }

    long getStartDelay() {
        return this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_START);
    }

    boolean isUsingTrash() {
        return !this.getConfiguration().getBoolean(Property.GC_TRASH_IGNORE);
    }

    int getNumDeleteThreads() {
        return this.getConfiguration().getCount(Property.GC_DELETE_THREADS);
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="main class can call System.exit")
    public void run() {
        VolumeManager fs = this.getContext().getVolumeManager();
        log.info("Trying to acquire ZooKeeper lock for garbage collector");
        try {
            this.getZooLock(this.startStatsService());
        }
        catch (Exception ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            System.exit(1);
        }
        try {
            long delay = this.getStartDelay();
            log.debug("Sleeping for {} milliseconds before beginning garbage collection cycles", (Object)delay);
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
            return;
        }
        ProbabilitySampler sampler = TraceUtil.probabilitySampler((double)this.getConfiguration().getFraction(Property.GC_TRACE_PERCENT));
        while (true) {
            try (TraceScope gcOuterSpan = Trace.startSpan((String)"gc", (Sampler)sampler);){
                try (TraceScope gcSpan = Trace.startSpan((String)"loop");){
                    long tStart = System.currentTimeMillis();
                    try {
                        System.gc();
                        this.status.current.started = System.currentTimeMillis();
                        new GarbageCollectionAlgorithm().collect(new GCEnv(RootTable.NAME));
                        new GarbageCollectionAlgorithm().collect(new GCEnv(MetadataTable.NAME));
                        log.info("Number of data file candidates for deletion: {}", (Object)this.status.current.candidates);
                        log.info("Number of data file candidates still in use: {}", (Object)this.status.current.inUse);
                        log.info("Number of successfully deleted data files: {}", (Object)this.status.current.deleted);
                        log.info("Number of data files delete failures: {}", (Object)this.status.current.errors);
                        this.status.current.finished = System.currentTimeMillis();
                        this.status.last = this.status.current;
                        this.status.current = new GcCycleStats();
                    }
                    catch (Exception e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                    }
                    long tStop = System.currentTimeMillis();
                    log.info(String.format("Collect cycle took %.2f seconds", (double)(tStop - tStart) / 1000.0));
                    try (TraceScope replSpan = Trace.startSpan((String)"replicationClose");){
                        CloseWriteAheadLogReferences closeWals = new CloseWriteAheadLogReferences(this.getContext());
                        closeWals.run();
                    }
                    catch (Exception e) {
                        log.error("Error trying to close write-ahead logs for replication table", (Throwable)e);
                    }
                    try (TraceScope waLogs = Trace.startSpan((String)"walogs");){
                        GarbageCollectWriteAheadLogs walogCollector = new GarbageCollectWriteAheadLogs(this.getContext(), fs, this.isUsingTrash());
                        log.info("Beginning garbage collection of write-ahead logs");
                        walogCollector.collect(this.status);
                    }
                    catch (Exception e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                try {
                    ServerContext accumuloClient = this.getContext();
                    accumuloClient.tableOperations().compact(MetadataTable.NAME, null, null, true, true);
                    accumuloClient.tableOperations().compact(RootTable.NAME, null, null, true, true);
                }
                catch (Exception e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
            try {
                long gcDelay = this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_DELAY);
                log.debug("Sleeping for {} milliseconds", (Object)gcDelay);
                Thread.sleep(gcDelay);
            }
            catch (InterruptedException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
                return;
            }
        }
    }

    boolean moveToTrash(Path path) throws IOException {
        VolumeManager fs = this.getContext().getVolumeManager();
        if (!this.isUsingTrash()) {
            return false;
        }
        try {
            return fs.moveToTrash(path);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    private void getZooLock(HostAndPort addr) throws KeeperException, InterruptedException {
        String path = this.getContext().getZooKeeperRoot() + "/gc/lock";
        ZooLock.LockWatcher lockWatcher = new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                Halt.halt((String)("GC lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)1);
            }

            public void unableToMonitorLockNode(Throwable e) {
                Halt.halt((int)-1, () -> log.error("FATAL: No longer able to monitor lock node ", e));
            }
        };
        while (true) {
            this.lock = new ZooLock(this.getContext().getZooReaderWriter(), path);
            if (this.lock.tryLock(lockWatcher, new ServerServices(addr.toString(), ServerServices.Service.GC_CLIENT).toString().getBytes())) {
                log.debug("Got GC ZooKeeper lock");
                return;
            }
            log.debug("Failed to get GC ZooKeeper lock, will retry");
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private HostAndPort startStatsService() {
        GCMonitorService.Processor processor;
        GCMonitorService.Iface rpcProxy = (GCMonitorService.Iface)TraceUtil.wrapService((Object)((Object)this));
        if (this.getContext().getThriftServerType() == ThriftServerType.SASL) {
            GCMonitorService.Iface tcProxy = (GCMonitorService.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, ((Object)((Object)this)).getClass(), (AccumuloConfiguration)this.getConfiguration());
            processor = new GCMonitorService.Processor(tcProxy);
        } else {
            processor = new GCMonitorService.Processor(rpcProxy);
        }
        int[] port = this.getConfiguration().getPort(Property.GC_PORT);
        HostAndPort[] addresses = TServerUtils.getHostAndPorts((String)this.opts.getAddress(), (int[])port);
        long maxMessageSize = this.getConfiguration().getAsBytes(Property.GENERAL_MAX_MESSAGE_SIZE);
        try {
            ServerAddress server = TServerUtils.startTServer((MetricsSystem)this.getMetricsSystem(), (AccumuloConfiguration)this.getConfiguration(), (ThriftServerType)this.getContext().getThriftServerType(), (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"GC Monitor Service", (int)2, (int)this.getConfiguration().getCount(Property.GENERAL_SIMPLETIMER_THREADPOOL_SIZE), (long)1000L, (long)maxMessageSize, (SslConnectionParams)this.getContext().getServerSslParams(), (SaslServerConnectionParams)this.getContext().getSaslParams(), (long)0L, (HostAndPort[])addresses);
            log.debug("Starting garbage collector listening on " + server.address);
            return server.address;
        }
        catch (Exception ex) {
            log.error("FATAL:", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    static boolean almostOutOfMemory(Runtime runtime) {
        return (float)(runtime.totalMemory() - runtime.freeMemory()) > 0.5f * (float)runtime.maxMemory();
    }

    private static void putMarkerDeleteMutation(String delete, BatchWriter writer) throws MutationsRejectedException {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.DeletesSection.getRowPrefix() + delete));
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        writer.addMutation(m);
    }

    static boolean isDir(String delete) {
        if (delete == null) {
            return false;
        }
        int slashCount = 0;
        for (int i = 0; i < delete.length(); ++i) {
            if (delete.charAt(i) != '/') continue;
            ++slashCount;
        }
        return slashCount == 1;
    }

    public GCStatus getStatus(TInfo info, TCredentials credentials) {
        return this.status;
    }

    private class GCEnv
    implements GarbageCollectionEnvironment {
        private String tableName;

        GCEnv(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public boolean getCandidates(String continuePoint, List<String> result) throws TableNotFoundException {
            Range range = MetadataSchema.DeletesSection.getRange();
            if (continuePoint != null && !continuePoint.isEmpty()) {
                String continueRow = MetadataSchema.DeletesSection.getRowPrefix() + continuePoint;
                range = new Range(new Key((CharSequence)continueRow).followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
            }
            Scanner scanner = SimpleGarbageCollector.this.getContext().createScanner(this.tableName, Authorizations.EMPTY);
            scanner.setRange(range);
            result.clear();
            for (Map.Entry entry : scanner) {
                String cand = ((Key)entry.getKey()).getRow().toString().substring(MetadataSchema.DeletesSection.getRowPrefix().length());
                result.add(cand);
                if (!SimpleGarbageCollector.almostOutOfMemory(Runtime.getRuntime())) continue;
                log.info("List of delete candidates has exceeded the memory threshold. Attempting to delete what has been gathered so far.");
                return true;
            }
            return false;
        }

        @Override
        public Iterator<String> getBlipIterator() throws TableNotFoundException {
            IsolatedScanner scanner = new IsolatedScanner(SimpleGarbageCollector.this.getContext().createScanner(this.tableName, Authorizations.EMPTY));
            scanner.setRange(MetadataSchema.BlipSection.getRange());
            return Iterators.transform((Iterator)scanner.iterator(), entry -> ((Key)entry.getKey()).getRow().toString().substring(MetadataSchema.BlipSection.getRowPrefix().length()));
        }

        @Override
        public Stream<GarbageCollectionEnvironment.Reference> getReferences() {
            Stream tabletStream = TabletsMetadata.builder().scanTable(this.tableName).checkConsistency().fetchDir().fetchFiles().fetchScans().build((AccumuloClient)SimpleGarbageCollector.this.getContext()).stream();
            Stream<GarbageCollectionEnvironment.Reference> refStream = tabletStream.flatMap(tm -> {
                Stream<GarbageCollectionEnvironment.Reference> refs = Stream.concat(tm.getFiles().stream(), tm.getScans().stream()).map(f -> new GarbageCollectionEnvironment.Reference(tm.getTableId(), (String)f, false));
                if (tm.getDir() != null) {
                    refs = Stream.concat(refs, Stream.of(new GarbageCollectionEnvironment.Reference(tm.getTableId(), tm.getDir(), true)));
                }
                return refs;
            });
            return refStream;
        }

        @Override
        public Set<TableId> getTableIDs() {
            return Tables.getIdToNameMap((ClientContext)SimpleGarbageCollector.this.getContext()).keySet();
        }

        @Override
        public void delete(SortedMap<String, String> confirmedDeletes) throws TableNotFoundException {
            VolumeManager fs = SimpleGarbageCollector.this.getContext().getVolumeManager();
            if (((SimpleGarbageCollector)SimpleGarbageCollector.this).opts.safeMode) {
                if (((SimpleGarbageCollector)SimpleGarbageCollector.this).opts.verbose) {
                    System.out.println("SAFEMODE: There are " + confirmedDeletes.size() + " data file candidates marked for deletion.%n          Examine the log files to identify them.%n");
                }
                log.info("SAFEMODE: Listing all data file candidates for deletion");
                for (String s : confirmedDeletes.values()) {
                    log.info("SAFEMODE: {}", (Object)s);
                }
                log.info("SAFEMODE: End candidates for deletion");
                return;
            }
            ServerContext c = SimpleGarbageCollector.this.getContext();
            BatchWriter writer = c.createBatchWriter(this.tableName, new BatchWriterConfig());
            Iterator<Map.Entry<String, String>> cdIter = confirmedDeletes.entrySet().iterator();
            String lastDir = null;
            while (cdIter.hasNext()) {
                Map.Entry<String, String> entry = cdIter.next();
                String relPath = entry.getKey();
                String absPath = fs.getFullPath(VolumeManager.FileType.TABLE, entry.getValue()).toString();
                if (SimpleGarbageCollector.isDir(relPath)) {
                    lastDir = absPath;
                    continue;
                }
                if (lastDir == null) continue;
                if (absPath.startsWith(lastDir)) {
                    log.debug("Ignoring {} because {} exist", (Object)entry.getValue(), (Object)lastDir);
                    try {
                        SimpleGarbageCollector.putMarkerDeleteMutation(entry.getValue(), writer);
                    }
                    catch (MutationsRejectedException e) {
                        throw new RuntimeException(e);
                    }
                    cdIter.remove();
                    continue;
                }
                lastDir = null;
            }
            BatchWriter finalWriter = writer;
            ExecutorService deleteThreadPool = Executors.newFixedThreadPool(SimpleGarbageCollector.this.getNumDeleteThreads(), (ThreadFactory)new NamingThreadFactory("deleting"));
            List replacements = ServerConstants.getVolumeReplacements((AccumuloConfiguration)SimpleGarbageCollector.this.getConfiguration(), (Configuration)SimpleGarbageCollector.this.getContext().getHadoopConf());
            for (String delete : confirmedDeletes.values()) {
                Runnable deleteTask = () -> {
                    try {
                        boolean removeFlag;
                        Path fullPath;
                        String switchedDelete = VolumeUtil.switchVolume((String)delete, (VolumeManager.FileType)VolumeManager.FileType.TABLE, (List)replacements);
                        if (switchedDelete != null) {
                            log.debug("Volume replaced {} -> {}", (Object)delete, (Object)switchedDelete);
                            fullPath = fs.getFullPath(VolumeManager.FileType.TABLE, switchedDelete);
                        } else {
                            fullPath = fs.getFullPath(VolumeManager.FileType.TABLE, delete);
                        }
                        log.debug("Deleting {}", (Object)fullPath);
                        if (SimpleGarbageCollector.this.moveToTrash(fullPath) || fs.deleteRecursively(fullPath)) {
                            removeFlag = true;
                            SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                            synchronized (simpleGarbageCollector) {
                                ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.deleted;
                            }
                        }
                        if (fs.exists(fullPath)) {
                            removeFlag = false;
                            SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                            synchronized (simpleGarbageCollector) {
                                ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                            }
                            log.warn("File exists, but was not deleted for an unknown reason: {}", (Object)fullPath);
                        } else {
                            removeFlag = true;
                            SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                            synchronized (simpleGarbageCollector) {
                                ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                            }
                            String[] parts = fullPath.toString().split("/tables")[1].split("/");
                            if (parts.length > 2) {
                                TableId tableId = TableId.of((String)parts[1]);
                                String tabletDir = parts[2];
                                SimpleGarbageCollector.this.getContext().getTableManager().updateTableStateCache(tableId);
                                TableState tableState = SimpleGarbageCollector.this.getContext().getTableManager().getTableState(tableId);
                                if (tableState != null && tableState != TableState.DELETING && !tabletDir.startsWith("c-")) {
                                    log.debug("File doesn't exist: {}", (Object)fullPath);
                                }
                            } else {
                                log.warn("Very strange path name: {}", (Object)delete);
                            }
                        }
                        if (removeFlag && finalWriter != null) {
                            SimpleGarbageCollector.putMarkerDeleteMutation(delete, finalWriter);
                        }
                    }
                    catch (Exception e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                    }
                };
                deleteThreadPool.execute(deleteTask);
            }
            deleteThreadPool.shutdown();
            try {
                while (!deleteThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e1) {
                log.error("{}", (Object)e1.getMessage(), (Object)e1);
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (MutationsRejectedException e) {
                    log.error("Problem removing entries from the metadata table: ", (Throwable)e);
                }
            }
        }

        @Override
        public void deleteTableDirIfEmpty(TableId tableID) throws IOException {
            VolumeManager fs = SimpleGarbageCollector.this.getContext().getVolumeManager();
            for (String dir : ServerConstants.getTablesDirs((ServerContext)SimpleGarbageCollector.this.getContext())) {
                FileStatus[] tabletDirs = null;
                try {
                    tabletDirs = fs.listStatus(new Path(dir + "/" + tableID));
                }
                catch (FileNotFoundException ex) {
                    continue;
                }
                if (tabletDirs.length != 0) continue;
                Path p = new Path(dir + "/" + tableID);
                log.debug("Removing table dir {}", (Object)p);
                if (SimpleGarbageCollector.this.moveToTrash(p)) continue;
                fs.delete(p);
            }
        }

        @Override
        public void incrementCandidatesStat(long i) {
            ((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.candidates += i;
        }

        @Override
        public void incrementInUseStat(long i) {
            ((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.inUse += i;
        }

        @Override
        public Iterator<Map.Entry<String, Replication.Status>> getReplicationNeededIterator() {
            ServerContext client = SimpleGarbageCollector.this.getContext();
            try {
                Scanner s = ReplicationTable.getScanner((AccumuloClient)client);
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                return Iterators.transform((Iterator)s.iterator(), input -> {
                    Replication.Status stat;
                    String file = ((Key)input.getKey()).getRow().toString();
                    try {
                        stat = Replication.Status.parseFrom((byte[])((Value)input.getValue()).get());
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("Could not deserialize protobuf for: {}", input.getKey());
                        stat = null;
                    }
                    return Maps.immutableEntry((Object)file, (Object)stat);
                });
            }
            catch (ReplicationTableOfflineException e) {
                return Collections.emptyIterator();
            }
        }
    }

    static class GCOpts
    extends ServerOpts {
        @Parameter(names={"-v", "--verbose"}, description="extra information will get printed to stdout also")
        boolean verbose = false;
        @Parameter(names={"-s", "--safemode"}, description="safe mode will not delete files")
        boolean safeMode = false;

        GCOpts() {
        }
    }
}

