/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapreduce;

import java.io.IOException;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.hadoop.mapreduce.FileOutputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.FileOutputFormatBuilderImpl;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.ConfiguratorBase;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.FileOutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class AccumuloFileOutputFormat
extends FileOutputFormat<Key, Value> {
    private static final Class<AccumuloFileOutputFormat> CLASS = AccumuloFileOutputFormat.class;

    public RecordWriter<Key, Value> getRecordWriter(TaskAttemptContext context) throws IOException {
        final Configuration conf = context.getConfiguration();
        final AccumuloConfiguration acuConf = FileOutputConfigurator.getAccumuloConfiguration(AccumuloFileOutputFormat.class, context.getConfiguration());
        String extension = acuConf.get(Property.TABLE_FILE_TYPE);
        final Path file = this.getDefaultWorkFile(context, "." + extension);
        final int visCacheSize = ConfiguratorBase.getVisibilityCacheSize(conf);
        return new RecordWriter<Key, Value>(){
            RFileWriter out = null;

            public void close(TaskAttemptContext context) throws IOException {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void write(Key key, Value value) throws IOException {
                if (this.out == null) {
                    this.out = RFile.newWriter().to(file.toString()).withFileSystem(file.getFileSystem(conf)).withTableProperties((Iterable)acuConf).withVisibilityCacheSize(visCacheSize).build();
                    this.out.startDefaultLocalityGroup();
                }
                this.out.append(key, value);
            }
        };
    }

    public static FileOutputFormatBuilder.PathParams<Job> configure() {
        return new FileOutputFormatBuilderImpl<Job>(CLASS);
    }
}

