/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class InputTableConfig
implements Writable {
    private Map<String, IteratorSetting> iterators = Collections.emptyMap();
    private List<Range> ranges = Collections.emptyList();
    private Collection<IteratorSetting.Column> columns = Collections.emptyList();
    private Optional<Authorizations> scanAuths = Optional.empty();
    private Optional<String> context = Optional.empty();
    private boolean autoAdjustRanges = true;
    private boolean useLocalIterators = false;
    private boolean useIsolatedScanners = false;
    private boolean offlineScan = false;
    private boolean batchScan = false;
    private SamplerConfiguration samplerConfig = null;
    private Map<String, String> executionHints = Collections.emptyMap();

    public InputTableConfig() {
    }

    public InputTableConfig(DataInput input) throws IOException {
        this.readFields(input);
    }

    public InputTableConfig setRanges(List<Range> ranges) {
        this.ranges = ranges;
        return this;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public InputTableConfig fetchColumns(Collection<IteratorSetting.Column> columns) {
        this.columns = columns;
        return this;
    }

    public Collection<IteratorSetting.Column> getFetchedColumns() {
        return this.columns != null ? this.columns : new HashSet<IteratorSetting.Column>();
    }

    public void addIterator(IteratorSetting cfg) {
        if (this.iterators.isEmpty()) {
            this.iterators = new LinkedHashMap<String, IteratorSetting>();
        }
        this.iterators.put(cfg.getName(), cfg);
    }

    public List<IteratorSetting> getIterators() {
        return new LinkedList<IteratorSetting>(this.iterators.values());
    }

    public InputTableConfig setAutoAdjustRanges(boolean autoAdjustRanges) {
        this.autoAdjustRanges = autoAdjustRanges;
        return this;
    }

    public boolean shouldAutoAdjustRanges() {
        return this.autoAdjustRanges;
    }

    public InputTableConfig setUseLocalIterators(boolean useLocalIterators) {
        this.useLocalIterators = useLocalIterators;
        return this;
    }

    public boolean shouldUseLocalIterators() {
        return this.useLocalIterators;
    }

    public InputTableConfig setOfflineScan(boolean offlineScan) {
        this.offlineScan = offlineScan;
        return this;
    }

    public boolean isOfflineScan() {
        return this.offlineScan;
    }

    public InputTableConfig setUseIsolatedScanners(boolean useIsolatedScanners) {
        this.useIsolatedScanners = useIsolatedScanners;
        return this;
    }

    public boolean shouldUseIsolatedScanners() {
        return this.useIsolatedScanners;
    }

    public void setUseBatchScan(boolean value) {
        this.batchScan = value;
    }

    public boolean shouldBatchScan() {
        return this.batchScan;
    }

    public void setSamplerConfiguration(SamplerConfiguration samplerConfiguration) {
        this.samplerConfig = samplerConfiguration;
    }

    public SamplerConfiguration getSamplerConfiguration() {
        return this.samplerConfig;
    }

    public void setExecutionHints(Map<String, String> executionHints) {
        this.executionHints = executionHints;
    }

    public Map<String, String> getExecutionHints() {
        return this.executionHints;
    }

    public Optional<Authorizations> getScanAuths() {
        return this.scanAuths;
    }

    public InputTableConfig setScanAuths(Authorizations scanAuths) {
        this.scanAuths = Optional.of(scanAuths);
        return this;
    }

    public Optional<String> getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = Optional.of(context);
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (this.iterators != null) {
            dataOutput.writeInt(this.iterators.size());
            for (IteratorSetting iteratorSetting : this.getIterators()) {
                iteratorSetting.write(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.ranges != null) {
            dataOutput.writeInt(this.ranges.size());
            for (Range range : this.ranges) {
                range.write(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.columns != null) {
            dataOutput.writeInt(this.columns.size());
            for (Pair pair : this.columns) {
                if (pair.getSecond() == null) {
                    dataOutput.writeInt(1);
                    ((Text)pair.getFirst()).write(dataOutput);
                    continue;
                }
                dataOutput.writeInt(2);
                ((Text)pair.getFirst()).write(dataOutput);
                ((Text)pair.getSecond()).write(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        dataOutput.writeBoolean(this.autoAdjustRanges);
        dataOutput.writeBoolean(this.useLocalIterators);
        dataOutput.writeBoolean(this.useIsolatedScanners);
        dataOutput.writeBoolean(this.offlineScan);
        if (this.samplerConfig == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            new SamplerConfigurationImpl(this.samplerConfig).write(dataOutput);
        }
        if (this.executionHints.isEmpty()) {
            dataOutput.writeInt(0);
        } else {
            dataOutput.writeInt(this.executionHints.size());
            for (Map.Entry entry : this.executionHints.entrySet()) {
                dataOutput.writeUTF((String)entry.getKey());
                dataOutput.writeUTF((String)entry.getValue());
            }
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        long iterSize = dataInput.readInt();
        if (iterSize > 0L) {
            this.iterators = new LinkedHashMap<String, IteratorSetting>();
        }
        int i = 0;
        while ((long)i < iterSize) {
            IteratorSetting newIter = new IteratorSetting(dataInput);
            this.iterators.put(newIter.getName(), newIter);
            ++i;
        }
        long rangeSize = dataInput.readInt();
        if (rangeSize > 0L) {
            this.ranges = new ArrayList<Range>();
        }
        int i2 = 0;
        while ((long)i2 < rangeSize) {
            Range range = new Range();
            range.readFields(dataInput);
            this.ranges.add(range);
            ++i2;
        }
        long columnSize = dataInput.readInt();
        if (columnSize > 0L) {
            this.columns = new HashSet<IteratorSetting.Column>();
        }
        int i3 = 0;
        while ((long)i3 < columnSize) {
            long numPairs = dataInput.readInt();
            Text colFam = new Text();
            colFam.readFields(dataInput);
            if (numPairs == 1L) {
                this.columns.add(new IteratorSetting.Column(colFam, null));
            } else if (numPairs == 2L) {
                Text colQual = new Text();
                colQual.readFields(dataInput);
                this.columns.add(new IteratorSetting.Column(colFam, colQual));
            }
            ++i3;
        }
        this.autoAdjustRanges = dataInput.readBoolean();
        this.useLocalIterators = dataInput.readBoolean();
        this.useIsolatedScanners = dataInput.readBoolean();
        this.offlineScan = dataInput.readBoolean();
        if (dataInput.readBoolean()) {
            this.samplerConfig = new SamplerConfigurationImpl(dataInput).toSamplerConfiguration();
        }
        this.executionHints = new HashMap<String, String>();
        int numHints = dataInput.readInt();
        for (int i4 = 0; i4 < numHints; ++i4) {
            String k = dataInput.readUTF();
            String v = dataInput.readUTF();
            this.executionHints.put(k, v);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputTableConfig that = (InputTableConfig)o;
        if (this.autoAdjustRanges != that.autoAdjustRanges) {
            return false;
        }
        if (this.offlineScan != that.offlineScan) {
            return false;
        }
        if (this.useIsolatedScanners != that.useIsolatedScanners) {
            return false;
        }
        if (this.useLocalIterators != that.useLocalIterators) {
            return false;
        }
        if (!Objects.equals(this.columns, that.columns)) {
            return false;
        }
        if (!Objects.equals(this.iterators, that.iterators)) {
            return false;
        }
        if (!Objects.equals(this.ranges, that.ranges)) {
            return false;
        }
        if (!Objects.equals(this.executionHints, that.executionHints)) {
            return false;
        }
        return Objects.equals(this.samplerConfig, that.samplerConfig);
    }

    public int hashCode() {
        int result = 31 * (this.iterators != null ? this.iterators.hashCode() : 0);
        result = 31 * result + (this.ranges != null ? this.ranges.hashCode() : 0);
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.autoAdjustRanges ? 1 : 0);
        result = 31 * result + (this.useLocalIterators ? 1 : 0);
        result = 31 * result + (this.useIsolatedScanners ? 1 : 0);
        result = 31 * result + (this.offlineScan ? 1 : 0);
        result = 31 * result + (this.samplerConfig == null ? 0 : this.samplerConfig.hashCode());
        result = 31 * result + (this.executionHints == null ? 0 : this.executionHints.hashCode());
        return result;
    }
}

