/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.replication;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.replication.DistributedWorkQueueWorkAssigner;
import org.apache.accumulo.server.replication.DistributedWorkQueueWorkAssignerHelper;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UnorderedWorkAssigner
extends DistributedWorkQueueWorkAssigner {
    private static final Logger log = LoggerFactory.getLogger(UnorderedWorkAssigner.class);
    private static final String NAME = "Unordered Work Assigner";
    private Set<String> queuedWork;

    public UnorderedWorkAssigner() {
    }

    public UnorderedWorkAssigner(AccumuloConfiguration conf, AccumuloClient client) {
        this.configure(conf, client);
    }

    public String getName() {
        return NAME;
    }

    protected Set<String> getQueuedWork() {
        return this.queuedWork;
    }

    protected void setQueuedWork(Set<String> queuedWork) {
        this.queuedWork = queuedWork;
    }

    @Override
    protected void initializeQueuedWork() {
        if (this.queuedWork != null) {
            return;
        }
        this.queuedWork = new HashSet<String>();
        while (true) {
            try {
                this.queuedWork.addAll(this.workQueue.getWorkQueued());
                return;
            }
            catch (KeeperException e) {
                if (KeeperException.Code.NONODE.equals((Object)e.code())) {
                    log.warn("Could not find ZK root for replication work queue, will retry", (Throwable)e);
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                log.error("Error reading existing queued replication work from ZooKeeper", (Throwable)e);
                throw new RuntimeException("Error reading existing queued replication work from ZooKeeper", e);
            }
            catch (InterruptedException e) {
                log.error("Error reading existing queued replication work from ZooKeeper", (Throwable)e);
                throw new RuntimeException("Error reading existing queued replication work from ZooKeeper", e);
            }
            break;
        }
    }

    @Override
    protected boolean queueWork(Path path, ReplicationTarget target) {
        String queueKey = DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)path.getName(), (ReplicationTarget)target);
        if (this.queuedWork.contains(queueKey)) {
            log.debug("{} is already queued to be replicated to {}, not re-queueing", (Object)path, (Object)target);
            return false;
        }
        try {
            log.debug("Queued work for {} and {}", (Object)queueKey, (Object)path);
            this.workQueue.addWork(queueKey, path.toString());
            this.queuedWork.add(queueKey);
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Could not queue work for {}", (Object)path, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    protected void cleanupFinishedWork() {
        Iterator<String> work = this.queuedWork.iterator();
        InstanceId instanceId = this.client.instanceOperations().getInstanceId();
        while (work.hasNext()) {
            String filename = work.next();
            if (this.zooCache.get(ZooUtil.getRoot((InstanceId)instanceId) + "/replication/workqueue/" + filename) != null) continue;
            work.remove();
        }
    }

    @Override
    protected boolean shouldQueueWork(ReplicationTarget target) {
        return true;
    }

    @Override
    protected int getQueueSize() {
        return this.queuedWork.size();
    }

    @Override
    protected Set<String> getQueuedWork(ReplicationTarget target) {
        String desiredQueueKeySuffix = "|" + target.getPeerName() + "|" + target.getRemoteIdentifier() + "|" + target.getSourceTableId();
        HashSet<String> queuedWorkForTarget = new HashSet<String>();
        for (String queuedWork : this.queuedWork) {
            if (!queuedWork.endsWith(desiredQueueKeySuffix)) continue;
            queuedWorkForTarget.add(queuedWork);
        }
        return queuedWorkForTarget;
    }

    @Override
    protected void removeQueuedWork(ReplicationTarget target, String queueKey) {
        this.queuedWork.remove(queueKey);
    }
}

